/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.osgi.util.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.fx.core.URLStreamHandler;
import org.eclipse.jdt.annotation.NonNull;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerService;

public class DelegatingURLStreamHandlerService
extends AbstractURLStreamHandlerService
implements URLStreamHandlerService {
    public final URLStreamHandler h;

    public DelegatingURLStreamHandlerService(URLStreamHandler h) {
        this.h = h;
    }

    public URLConnection openConnection(URL u) throws IOException {
        return new URLConnectionImpl(u, this.h);
    }

    static class URLConnectionImpl
    extends URLConnection {
        private final URLStreamHandler h;

        protected URLConnectionImpl(@NonNull URL url, @NonNull URLStreamHandler h) {
            super(url);
            this.h = h;
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.h.createStream(this.getURL());
        }
    }
}

