/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.panes;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;

public class GridData {
    private ObjectProperty<Alignment> verticalAlignment = new SimpleObjectProperty((Object)this, "verticalAlignment", (Object)Alignment.CENTER);
    private ObjectProperty<Alignment> horizontalAlignment = new SimpleObjectProperty((Object)this, "horizontalAlignment", (Object)Alignment.BEGINNING);
    private IntegerProperty widthHint = new SimpleIntegerProperty((Object)this, "widthHint", -1);
    private IntegerProperty heightHint = new SimpleIntegerProperty((Object)this, "heightHint", -1);
    private IntegerProperty horizontalIndent = new SimpleIntegerProperty((Object)this, "horizontalIndent");
    private IntegerProperty verticalIndent = new SimpleIntegerProperty((Object)this, "verticalIndent");
    private IntegerProperty horizontalSpan = new SimpleIntegerProperty((Object)this, "horizontalSpan", 1);
    private IntegerProperty verticalSpan = new SimpleIntegerProperty((Object)this, "verticalSpan", 1);
    private BooleanProperty grabExcessHorizontalSpace = new SimpleBooleanProperty((Object)this, "grabExcessHorizontalSpace", false);
    private BooleanProperty grabExcessVerticalSpace = new SimpleBooleanProperty((Object)this, "grabExcessVerticalSpace", false);
    private IntegerProperty minimumWidth = new SimpleIntegerProperty((Object)this, "minimumWidth", 0);
    private IntegerProperty minimumHeight = new SimpleIntegerProperty((Object)this, "minimumHeight", 0);
    private BooleanProperty exclude = new SimpleBooleanProperty((Object)this, "exclude", false);
    public static final int VERTICAL_ALIGN_BEGINNING = 2;
    public static final int VERTICAL_ALIGN_CENTER = 4;
    public static final int VERTICAL_ALIGN_END = 8;
    public static final int VERTICAL_ALIGN_FILL = 16;
    public static final int HORIZONTAL_ALIGN_BEGINNING = 32;
    public static final int HORIZONTAL_ALIGN_CENTER = 64;
    public static final int HORIZONTAL_ALIGN_END = 128;
    public static final int HORIZONTAL_ALIGN_FILL = 256;
    public static final int GRAB_HORIZONTAL = 512;
    public static final int GRAB_VERTICAL = 1024;
    public static final int FILL_VERTICAL = 1040;
    public static final int FILL_HORIZONTAL = 768;
    public static final int FILL_BOTH = 1808;
    double cacheWidth = -1.0;
    double cacheHeight = -1.0;
    double defaultWhint;
    double defaultHhint;
    double defaultWidth = -1.0;
    double defaultHeight = -1.0;
    double currentWhint;
    double currentHhint;
    double currentWidth = -1.0;
    double currentHeight = -1.0;

    public GridData() {
    }

    public GridData(int style) {
        if ((style & 2) != 0) {
            this.setVerticalAlignment(Alignment.BEGINNING);
        }
        if ((style & 4) != 0) {
            this.setVerticalAlignment(Alignment.CENTER);
        }
        if ((style & 0x10) != 0) {
            this.setVerticalAlignment(Alignment.FILL);
        }
        if ((style & 8) != 0) {
            this.setVerticalAlignment(Alignment.END);
        }
        if ((style & 0x20) != 0) {
            this.setHorizontalAlignment(Alignment.BEGINNING);
        }
        if ((style & 0x40) != 0) {
            this.setHorizontalAlignment(Alignment.CENTER);
        }
        if ((style & 0x100) != 0) {
            this.setHorizontalAlignment(Alignment.FILL);
        }
        if ((style & 0x80) != 0) {
            this.setHorizontalAlignment(Alignment.END);
        }
        this.setGrabExcessHorizontalSpace((style & 0x200) != 0);
        this.setGrabExcessVerticalSpace((style & 0x400) != 0);
    }

    public GridData(Alignment horizontalAlignment, Alignment verticalAlignment, boolean grabExcessHorizontalSpace, boolean grabExcessVerticalSpace) {
        this(horizontalAlignment, verticalAlignment, grabExcessHorizontalSpace, grabExcessVerticalSpace, 1, 1);
    }

    public GridData(Alignment horizontalAlignment, Alignment verticalAlignment, boolean grabExcessHorizontalSpace, boolean grabExcessVerticalSpace, int horizontalSpan, int verticalSpan) {
        this.setHorizontalAlignment(horizontalAlignment);
        this.setVerticalAlignment(verticalAlignment);
        this.setGrabExcessHorizontalSpace(grabExcessHorizontalSpace);
        this.setGrabExcessVerticalSpace(grabExcessVerticalSpace);
        this.setHorizontalSpan(horizontalSpan);
        this.setVerticalSpan(verticalSpan);
    }

    public GridData(int width, int height) {
        this.setWidthHint(width);
        this.setHeightHint(height);
    }

    void computeSize(Node control, int wHint, int hHint, boolean flushCache) {
        if (this.cacheWidth != -1.0 && this.cacheHeight != -1.0) {
            return;
        }
        if (wHint == this.getWidthHint() && hHint == this.getHeightHint()) {
            if (this.defaultWidth == -1.0 || this.defaultHeight == -1.0 || (double)wHint != this.defaultWhint || (double)hHint != this.defaultHhint) {
                this.defaultWhint = wHint;
                this.defaultHhint = hHint;
                this.defaultWidth = wHint == -1 ? Math.ceil(control.prefWidth((double)hHint)) : Math.ceil(this.defaultWhint);
                this.defaultHeight = hHint == -1 ? Math.ceil(control.prefHeight((double)wHint)) : Math.ceil(this.defaultHhint);
            }
            this.cacheWidth = this.defaultWidth;
            this.cacheHeight = this.defaultHeight;
            return;
        }
        if (this.currentWidth == -1.0 || this.currentHeight == -1.0 || (double)wHint != this.currentWhint || (double)hHint != this.currentHhint) {
            this.currentWhint = wHint;
            this.currentHhint = hHint;
            this.currentWidth = Math.ceil(control.getLayoutBounds().getWidth());
            this.currentHeight = Math.ceil(control.getLayoutBounds().getHeight());
        }
        this.cacheWidth = this.currentWidth;
        this.cacheHeight = this.currentHeight;
    }

    void flushCache() {
        this.cacheHeight = -1.0;
        this.cacheWidth = -1.0;
        this.defaultHeight = -1.0;
        this.defaultWidth = -1.0;
        this.currentHeight = -1.0;
        this.currentWidth = -1.0;
    }

    String getName() {
        String string = this.getClass().getName();
        int index = string.lastIndexOf(46);
        if (index == -1) {
            return string;
        }
        return string.substring(index + 1, string.length());
    }

    public void setExclude(boolean value) {
        this.excludeProperty().set(value);
    }

    public boolean isExclude() {
        return this.excludeProperty().get();
    }

    public BooleanProperty excludeProperty() {
        return this.exclude;
    }

    public void setGrabExcessHorizontalSpace(boolean value) {
        this.grabExcessHorizontalSpaceProperty().set(value);
    }

    public boolean isGrabExcessHorizontalSpace() {
        return this.grabExcessHorizontalSpaceProperty().get();
    }

    public BooleanProperty grabExcessHorizontalSpaceProperty() {
        return this.grabExcessHorizontalSpace;
    }

    public void setGrabExcessVerticalSpace(boolean value) {
        this.grabExcessVerticalSpaceProperty().set(value);
    }

    public boolean isGrabExcessVerticalSpace() {
        return this.grabExcessVerticalSpaceProperty().get();
    }

    public BooleanProperty grabExcessVerticalSpaceProperty() {
        return this.grabExcessVerticalSpace;
    }

    public void setHeightHint(int value) {
        this.heightHintProperty().set(value);
    }

    public int getHeightHint() {
        return this.heightHintProperty().get();
    }

    public IntegerProperty heightHintProperty() {
        return this.heightHint;
    }

    public void setHorizontalAlignment(Alignment value) {
        this.horizontalAlignmentProperty().set((Object)value);
    }

    public Alignment getHorizontalAlignment() {
        return (Alignment)((Object)this.horizontalAlignmentProperty().get());
    }

    public ObjectProperty<Alignment> horizontalAlignmentProperty() {
        return this.horizontalAlignment;
    }

    public void setHorizontalIndent(int value) {
        this.horizontalIndentProperty().set(value);
    }

    public int getHorizontalIndent() {
        return this.horizontalIndentProperty().get();
    }

    public IntegerProperty horizontalIndentProperty() {
        return this.horizontalIndent;
    }

    public void setHorizontalSpan(int value) {
        this.horizontalSpanProperty().set(value);
    }

    public int getHorizontalSpan() {
        return this.horizontalSpanProperty().get();
    }

    public IntegerProperty horizontalSpanProperty() {
        return this.horizontalSpan;
    }

    public void setMinimumHeight(int value) {
        this.minimumHeightProperty().set(value);
    }

    public int getMinimumHeight() {
        return this.minimumHeightProperty().get();
    }

    public IntegerProperty minimumHeightProperty() {
        return this.minimumHeight;
    }

    public void setMinimumWidth(int value) {
        this.minimumWidthProperty().set(value);
    }

    public int getMinimumWidth() {
        return this.minimumWidthProperty().get();
    }

    public IntegerProperty minimumWidthProperty() {
        return this.minimumWidth;
    }

    public void setVerticalAlignment(Alignment value) {
        this.verticalAlignmentProperty().set((Object)value);
    }

    public Alignment getVerticalAlignment() {
        return (Alignment)((Object)this.verticalAlignmentProperty().get());
    }

    public ObjectProperty<Alignment> verticalAlignmentProperty() {
        return this.verticalAlignment;
    }

    public void setVerticalIndent(int value) {
        this.verticalIndentProperty().set(value);
    }

    public int getVerticalIndent() {
        return this.verticalIndentProperty().get();
    }

    public IntegerProperty verticalIndentProperty() {
        return this.verticalIndent;
    }

    public void setVerticalSpan(int value) {
        this.verticalSpanProperty().set(value);
    }

    public int getVerticalSpan() {
        return this.verticalSpanProperty().get();
    }

    public IntegerProperty verticalSpanProperty() {
        return this.verticalSpan;
    }

    public void setWidthHint(int value) {
        this.widthHintProperty().set(value);
    }

    public int getWidthHint() {
        return this.widthHintProperty().get();
    }

    public IntegerProperty widthHintProperty() {
        return this.widthHint;
    }

    public String toString() {
        Object hAlign = "";
        switch (this.getHorizontalAlignment()) {
            case FILL: {
                hAlign = "SWT.FILL";
                break;
            }
            case BEGINNING: {
                hAlign = "SWT.BEGINNING";
                break;
            }
            case END: {
                hAlign = "GridData.END";
                break;
            }
            case CENTER: {
                hAlign = "GridData.CENTER";
                break;
            }
            default: {
                hAlign = "Undefined " + String.valueOf((Object)this.getHorizontalAlignment());
            }
        }
        Object vAlign = "";
        switch (this.getVerticalAlignment()) {
            case FILL: {
                vAlign = "SWT.FILL";
                break;
            }
            case BEGINNING: {
                vAlign = "SWT.BEGINNING";
                break;
            }
            case END: {
                vAlign = "SWT.END";
                break;
            }
            case CENTER: {
                vAlign = "SWT.CENTER";
                break;
            }
            default: {
                vAlign = "Undefined " + String.valueOf((Object)this.getVerticalAlignment());
            }
        }
        Object string = this.getName() + " {";
        string = (String)string + "horizontalAlignment=" + (String)hAlign + " ";
        if (this.getHorizontalIndent() != 0) {
            string = (String)string + "horizontalIndent=" + this.getHorizontalIndent() + " ";
        }
        if (this.getHorizontalSpan() != 1) {
            string = (String)string + "horizontalSpan=" + this.getHorizontalSpan() + " ";
        }
        if (this.isGrabExcessHorizontalSpace()) {
            string = (String)string + "grabExcessHorizontalSpace=" + this.isGrabExcessHorizontalSpace() + " ";
        }
        if (this.getWidthHint() != -1) {
            string = (String)string + "widthHint=" + this.getWidthHint() + " ";
        }
        if (this.getMinimumWidth() != 0) {
            string = (String)string + "minimumWidth=" + this.getMinimumWidth() + " ";
        }
        string = (String)string + "verticalAlignment=" + (String)vAlign + " ";
        if (this.getVerticalIndent() != 0) {
            string = (String)string + "verticalIndent=" + this.getVerticalIndent() + " ";
        }
        if (this.getVerticalSpan() != 1) {
            string = (String)string + "verticalSpan=" + this.getVerticalSpan() + " ";
        }
        if (this.isGrabExcessVerticalSpace()) {
            string = (String)string + "grabExcessVerticalSpace=" + this.isGrabExcessVerticalSpace() + " ";
        }
        if (this.getHeightHint() != -1) {
            string = (String)string + "heightHint=" + this.getHeightHint() + " ";
        }
        if (this.getMinimumHeight() != 0) {
            string = (String)string + "minimumHeight=" + this.getMinimumHeight() + " ";
        }
        if (this.isExclude()) {
            string = (String)string + "exclude=" + this.isExclude() + " ";
        }
        string = ((String)string).trim();
        string = (String)string + "}";
        return string;
    }

    public static enum Alignment {
        BEGINNING,
        CENTER,
        END,
        FILL;

    }
}

