/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.linking.impl;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.ValueConverterWithValueException;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class LinkingHelper {
    @Inject
    private IValueConverterService valueConverter;

    public void setValueConverter(IValueConverterService valueConverter) {
        this.valueConverter = valueConverter;
    }

    public String getRuleNameFrom(EObject grammarElement) {
        AbstractRule rule = this.getRuleFrom(grammarElement);
        return rule != null ? rule.getName() : null;
    }

    public AbstractRule getRuleFrom(EObject grammarElement) {
        if (!(grammarElement instanceof Keyword || grammarElement instanceof RuleCall || grammarElement instanceof CrossReference)) {
            throw new IllegalArgumentException("grammarElement is of type: '" + grammarElement.eClass().getName() + "'");
        }
        EObject elementToUse = grammarElement;
        if (grammarElement instanceof CrossReference) {
            elementToUse = ((CrossReference)grammarElement).getTerminal();
        }
        if (elementToUse instanceof RuleCall) {
            return ((RuleCall)elementToUse).getRule();
        }
        return null;
    }

    public String getCrossRefNodeAsString(INode node, boolean convert) {
        String convertMe = NodeModelUtils.getTokenText(node);
        if (!convert) {
            return convertMe;
        }
        try {
            String ruleName = this.getRuleNameFrom(node.getGrammarElement());
            if (ruleName == null) {
                return convertMe;
            }
            Object result = this.valueConverter.toValue(convertMe, ruleName, node);
            return result != null ? result.toString() : null;
        }
        catch (ValueConverterWithValueException ex) {
            Object result = ex.getValue();
            return result != null ? result.toString() : null;
        }
        catch (ValueConverterException ex) {
            throw new IllegalNodeException(node, (Throwable)ex);
        }
    }
}

