/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx.widget;

import java.util.List;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WLayoutedWidget;
import org.eclipse.fx.ui.workbench.renderers.fx.widget.WWidgetImpl;

public abstract class WLayoutedWidgetImpl<N, NN extends Node, M extends MUIElement>
extends WWidgetImpl<N, M>
implements WLayoutedWidget<M> {
    private Node staticLayoutGroup;
    private double weight = 10.0;
    @Inject
    @Log
    protected Logger logger;

    protected abstract NN getWidgetNode();

    public Node getStaticLayoutNode() {
        if (this.staticLayoutGroup == null) {
            this.staticLayoutGroup = this.createStaticLayoutNode();
        }
        return this.staticLayoutGroup;
    }

    protected Node createStaticLayoutNode() {
        Pane staticLayoutGroup = this.createStaticPane();
        NN n = this.getWidgetNode();
        if (n != null) {
            staticLayoutGroup.getChildren().add(n);
        } else {
            this.logger.log(Logger.Level.ERROR, "No widget node to attach");
        }
        return staticLayoutGroup;
    }

    protected Pane createStaticPane() {
        return new StackPane();
    }

    public void addStyleClasses(List<String> classnames) {
        this.getWidgetNode().getStyleClass().addAll(classnames);
    }

    public void addStyleClasses(String ... classnames) {
        this.getWidgetNode().getStyleClass().addAll((Object[])classnames);
    }

    public void setStyleId(String id) {
        this.getWidgetNode().setId(id);
    }

    @Override
    protected void setUserData(WWidgetImpl<N, M> widget) {
        this.getWidgetNode().setUserData(widget);
    }

    public double getWeight() {
        return this.weight;
    }

    @Inject
    void setContainerData(@Named(value="containerData") @Optional String data) {
        if (data != null) {
            try {
                this.weight = Double.parseDouble(data);
                return;
            }
            catch (Throwable throwable) {}
        }
        this.weight = 10.0;
    }
}

