/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.stage.Window;
import org.eclipse.fx.ui.dialogs.Dialog;
import org.eclipse.fx.ui.panes.GridLayoutPane;

public class MessageDialog
extends Dialog {
    private final Type type;
    private final String message;
    private final String[] dialogButtonLabels;
    private final int okButton;
    private final int cancelButton;

    MessageDialog(Window parent, String windowTitle, String message, Type type, int okButton, int cancelButton, String ... dialogButtonLabels) {
        super(parent, windowTitle);
        this.type = type;
        this.message = message;
        this.dialogButtonLabels = dialogButtonLabels;
        this.okButton = okButton;
        this.cancelButton = cancelButton;
    }

    @Override
    protected Node createDialogArea() {
        GridLayoutPane b = new GridLayoutPane();
        b.setHorizontalSpacing(20);
        b.setNumColumns(2);
        b.getStyleClass().add((Object)("messagedialog-" + this.type.name().toLowerCase()));
        ImageView view = new ImageView();
        view.getStyleClass().add((Object)"messagedialog-icon");
        b.getChildren().add((Object)view);
        Label l = new Label(this.message);
        l.getStyleClass().add((Object)"messagedialog-message");
        b.getChildren().add((Object)l);
        return b;
    }

    @Override
    protected List<String> getStylesheets() {
        ArrayList<String> list = new ArrayList<String>(super.getStylesheets());
        list.add(0, MessageDialog.class.getResource("message_dialog.css").toExternalForm());
        return list;
    }

    @Override
    protected boolean isOkDefault(int buttonId) {
        return this.okButton == buttonId;
    }

    @Override
    protected boolean isCancelDefault(int buttonId) {
        return this.cancelButton == buttonId;
    }

    @Override
    protected List<Button> createButtonsForBar() {
        ArrayList<Button> rv = new ArrayList<Button>();
        int i = 0;
        while (i < this.dialogButtonLabels.length) {
            rv.add(this.createButtonForBar(i, this.dialogButtonLabels[i], this.isOkDefault(i), this.isCancelDefault(i)));
            ++i;
        }
        return rv;
    }

    @Override
    protected void buttonPressed(int type) {
        this.setReturnCode(type);
        this.close();
    }

    public static void openErrorDialog(Window parent, String title, String message) {
        new MessageDialog(parent, title, message, Type.ERROR, 0, 0, "Ok").open();
    }

    public static void openWarningDialog(Window parent, String title, String message) {
        new MessageDialog(parent, title, message, Type.WARNING, 0, 0, "Ok").open();
    }

    public static void openInformationDialog(Window parent, String title, String message) {
        new MessageDialog(parent, title, message, Type.INFORMATION, 0, 0, "Ok").open();
    }

    public static QuestionResult openQuestionDialog(Window parent, String title, String message) {
        return MessageDialog.openQuestionDialog(parent, title, message, QuestionResult.YES);
    }

    public static QuestionResult openQuestionDialog(Window parent, String title, String message, QuestionResult defaultValue) {
        return QuestionResult.fromIndex(new MessageDialog(parent, title, message, Type.QUESTION, defaultValue == QuestionResult.YES ? 0 : 1, defaultValue == QuestionResult.YES ? 1 : 0, "Yes", "No").open());
    }

    public static QuestionCancelResult openQuestionCancelDialog(Window parent, String title, String message) {
        return MessageDialog.openQuestionCancelDialog(parent, title, message, QuestionCancelResult.YES);
    }

    public static QuestionCancelResult openQuestionCancelDialog(Window parent, String title, String message, QuestionCancelResult defaultValue) {
        int idx;
        switch (defaultValue) {
            case CANCEL: {
                idx = 2;
                break;
            }
            case NO: {
                idx = 1;
                break;
            }
            default: {
                idx = 0;
            }
        }
        return QuestionCancelResult.fromIndex(new MessageDialog(parent, title, message, Type.QUESTION, idx, 2, "Yes", "No", "Cancel").open());
    }

    public static ConfirmResult openConfirmDialog(Window parent, String title, String message) {
        return MessageDialog.openConfirmDialog(parent, title, message, ConfirmResult.OK);
    }

    public static ConfirmResult openConfirmDialog(Window parent, String title, String message, ConfirmResult defaultValue) {
        return ConfirmResult.fromIndex(new MessageDialog(parent, title, message, Type.CONFIRM, defaultValue == ConfirmResult.OK ? 0 : 1, 1, "Ok", "Cancel").open());
    }

    public static enum ConfirmResult {
        OK(0),
        CANCEL(1);

        private final int index;

        private ConfirmResult(int index) {
            this.index = index;
        }

        static ConfirmResult fromIndex(int index) {
            if (index == ConfirmResult.OK.index) {
                return OK;
            }
            return CANCEL;
        }
    }

    public static enum QuestionCancelResult {
        YES(0),
        NO(1),
        CANCEL(2);

        private final int index;

        private QuestionCancelResult(int index) {
            this.index = index;
        }

        static QuestionCancelResult fromIndex(int index) {
            if (index == QuestionCancelResult.YES.index) {
                return YES;
            }
            if (index == QuestionCancelResult.NO.index) {
                return NO;
            }
            return CANCEL;
        }
    }

    public static enum QuestionResult {
        YES(0),
        NO(1);

        private final int index;

        private QuestionResult(int index) {
            this.index = index;
        }

        static QuestionResult fromIndex(int index) {
            if (index == QuestionResult.YES.index) {
                return YES;
            }
            return NO;
        }
    }

    public static enum Type {
        CUSTOM,
        QUESTION,
        INFORMATION,
        WARNING,
        ERROR,
        CONFIRM,
        QUESTION_CANCEL;

    }
}

