/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet;

import org.eclipse.emf.codegen.jet.JETGenerator;

public class JETCharDataGenerator
implements JETGenerator {
    protected static final String FUNCTION_CALL_BEGIN = "stringBuffer.append(";
    protected static final String FUNCTION_CALL_END = ");";
    protected static final String NEW_LINE_BEGIN = "NL + ";
    protected static final String NEW_LINE_MIDDLE = "\" + NL + \"";
    protected static final String NEW_LINE_END = " + NL";
    protected char[] characters;

    public JETCharDataGenerator(char[] characters) {
        this.characters = characters;
    }

    public String generate() {
        StringBuffer stringBuffer = new StringBuffer(this.characters.length + 16);
        stringBuffer.append(FUNCTION_CALL_BEGIN);
        stringBuffer.append(this.generateCharData());
        stringBuffer.append(FUNCTION_CALL_END);
        return stringBuffer.toString();
    }

    protected String generateCharData() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBufferTail = new StringBuffer();
        int limit = this.characters.length - 1;
        block15: while (limit >= 0) {
            char ch = this.characters[limit];
            switch (ch) {
                case '\r': {
                    break;
                }
                case '\n': {
                    stringBufferTail.append(NEW_LINE_END);
                    break;
                }
                default: {
                    ++limit;
                    break block15;
                }
            }
            --limit;
        }
        if (limit < 0) {
            if (stringBufferTail.length() == 0) {
                stringBuffer.append("\"\"");
            } else {
                stringBuffer.append(stringBufferTail.toString().substring(3));
            }
        } else {
            char ch;
            int i = 0;
            block16: while (i <= limit) {
                ch = this.characters[i];
                switch (ch) {
                    case '\r': {
                        break;
                    }
                    case '\n': {
                        stringBuffer.append(NEW_LINE_BEGIN);
                        break;
                    }
                    default: {
                        break block16;
                    }
                }
                ++i;
            }
            stringBuffer.append('\"');
            while (i < limit) {
                ch = this.characters[i];
                switch (ch) {
                    case '\"': {
                        stringBuffer.append("\\\"");
                        break;
                    }
                    case '\\': {
                        stringBuffer.append("\\\\");
                        break;
                    }
                    case '\r': {
                        break;
                    }
                    case '\n': {
                        stringBuffer.append(NEW_LINE_MIDDLE);
                        break;
                    }
                    case '\t': {
                        stringBuffer.append("\\t");
                        break;
                    }
                    default: {
                        stringBuffer.append(ch);
                    }
                }
                ++i;
            }
            stringBuffer.append('\"');
            stringBuffer.append(stringBufferTail.toString());
        }
        return stringBuffer.toString();
    }
}

