/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.nd;

import org.eclipse.jdt.internal.core.nd.AbstractTypeFactory;
import org.eclipse.jdt.internal.core.nd.ITypeFactory;
import org.eclipse.jdt.internal.core.nd.Nd;

public class PrimitiveTypes {
    public static final ITypeFactory<Long> Pointer = new AbstractTypeFactory<Long>(){

        @Override
        public Long create(Nd dom, long address) {
            return dom.getDB().getRecPtr(address);
        }

        @Override
        public int getRecordSize() {
            return 4;
        }

        @Override
        public Class<?> getElementClass() {
            return Long.class;
        }
    };
    public static final ITypeFactory<Short> Short = new AbstractTypeFactory<Short>(){

        @Override
        public Short create(Nd dom, long address) {
            return dom.getDB().getShort(address);
        }

        @Override
        public int getRecordSize() {
            return 2;
        }

        @Override
        public Class<?> getElementClass() {
            return Short.class;
        }
    };
    public static final ITypeFactory<Integer> Integer = new AbstractTypeFactory<Integer>(){

        @Override
        public Integer create(Nd dom, long address) {
            return dom.getDB().getInt(address);
        }

        @Override
        public int getRecordSize() {
            return 4;
        }

        @Override
        public Class<?> getElementClass() {
            return Integer.class;
        }
    };
}

