/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.lifecyclemapping.discovery;

import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.ILifecycleMappingElement;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.ILifecycleMappingRequirement;

public class PackagingTypeMappingConfiguration
implements ILifecycleMappingElement {
    private final String packaging;
    private final String lifecycleMappingId;
    private final ILifecycleMappingRequirement requirement;

    public PackagingTypeMappingConfiguration(String packaging, String lifecycleMappingId) {
        this.packaging = packaging;
        this.lifecycleMappingId = lifecycleMappingId;
        this.requirement = lifecycleMappingId == null ? new PackagingTypeMappingRequirement(packaging) : new LifecycleStrategyMappingRequirement(packaging, lifecycleMappingId);
    }

    public String getPackaging() {
        return this.packaging;
    }

    public String getLifecycleMappingId() {
        return this.lifecycleMappingId;
    }

    public int hashCode() {
        int hash = this.packaging.hashCode();
        hash = 17 * hash + (this.lifecycleMappingId != null ? this.lifecycleMappingId.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PackagingTypeMappingConfiguration)) {
            return false;
        }
        PackagingTypeMappingConfiguration other = (PackagingTypeMappingConfiguration)obj;
        return this.packaging.equals(other.packaging) && PackagingTypeMappingConfiguration.eq(this.lifecycleMappingId, other.lifecycleMappingId);
    }

    private static <T> boolean eq(T a, T b) {
        return a != null ? a.equals(b) : b == null;
    }

    @Override
    public ILifecycleMappingRequirement getLifecycleMappingRequirement() {
        return this.requirement;
    }

    public static class LifecycleStrategyMappingRequirement
    implements ILifecycleMappingRequirement {
        private final String packaging;
        private final String lifecycleMappingId;

        public LifecycleStrategyMappingRequirement(String packaging, String lifecycleMappingId) {
            this.packaging = packaging;
            this.lifecycleMappingId = lifecycleMappingId;
        }

        public int hashCode() {
            return this.lifecycleMappingId.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LifecycleStrategyMappingRequirement)) {
                return false;
            }
            LifecycleStrategyMappingRequirement other = (LifecycleStrategyMappingRequirement)obj;
            return this.lifecycleMappingId.equals(other.lifecycleMappingId);
        }

        public String getLifecycleMappingId() {
            return this.lifecycleMappingId;
        }

        public String getPackaging() {
            return this.packaging;
        }
    }

    public static class PackagingTypeMappingRequirement
    implements ILifecycleMappingRequirement {
        private String packaging;

        public PackagingTypeMappingRequirement(String packaging) {
            this.packaging = packaging;
        }

        public int hashCode() {
            return this.packaging.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PackagingTypeMappingRequirement)) {
                return false;
            }
            PackagingTypeMappingRequirement other = (PackagingTypeMappingRequirement)obj;
            return this.packaging.equals(other.packaging);
        }

        public String getPackaging() {
            return this.packaging;
        }
    }
}

