/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.expression;

import org.eclipse.internal.xtend.expression.ast.SyntaxElement;

public class AnalysationIssue {
    public static final AnalysationIssueType INCOMPATIBLE_TYPES = new AnalysationIssueType("Incompatible types");
    public static final AnalysationIssueType UNNECESSARY_CAST = new AnalysationIssueType("Unnecessary cast");
    public static final AnalysationIssueType FEATURE_NOT_FOUND = new AnalysationIssueType("Callable not found");
    public static final AnalysationIssueType TYPE_NOT_FOUND = new AnalysationIssueType("AnalysationIssueType not found");
    public static final AnalysationIssueType INTERNAL_ERROR = new AnalysationIssueType("Internal error");
    public static final AnalysationIssueType JAVA_TYPE_NOT_FOUND = new AnalysationIssueType("Java AnalysationIssueType not found");
    public static final AnalysationIssueType SYNTAX_ERROR = new AnalysationIssueType("Syntax error");
    public static final AnalysationIssueType RESOURCE_NOT_FOUND = new AnalysationIssueType("Resource not found");
    private final AnalysationIssueType analysationIssueType;
    private final String message;
    private final SyntaxElement element;
    private final AnalysationIssueSeverity severity;
    private int onLine;

    public AnalysationIssue(AnalysationIssueType analysationIssueType, String message, SyntaxElement element) {
        this(analysationIssueType, message, element, false);
    }

    public AnalysationIssue(AnalysationIssueType analysationIssueType, String message, SyntaxElement element, boolean warning) {
        if (analysationIssueType == null || message == null || message.length() == 0 || element == null) {
            throw new IllegalArgumentException();
        }
        this.analysationIssueType = analysationIssueType;
        this.message = message;
        this.element = element;
        this.severity = warning ? AnalysationIssueSeverity.WARNING : AnalysationIssueSeverity.ERROR;
    }

    public AnalysationIssue(AnalysationIssueType analysationIssueType, String message, SyntaxElement element, boolean warning, int onLine) {
        if (analysationIssueType == null || message == null || message.length() == 0 || element == null) {
            throw new IllegalArgumentException();
        }
        this.analysationIssueType = analysationIssueType;
        this.message = message;
        this.element = element;
        this.severity = warning ? AnalysationIssueSeverity.WARNING : AnalysationIssueSeverity.ERROR;
        this.onLine = onLine;
    }

    public SyntaxElement getElement() {
        return this.element;
    }

    public String getMessage() {
        return this.message;
    }

    public AnalysationIssueType getType() {
        return this.analysationIssueType;
    }

    public boolean isError() {
        return this.severity == AnalysationIssueSeverity.ERROR;
    }

    public boolean isWarning() {
        return this.severity == AnalysationIssueSeverity.WARNING;
    }

    public int getOnLine() {
        return this.onLine;
    }

    public String toString() {
        return "[" + this.analysationIssueType.name + "] - " + this.message + " : " + this.element;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.analysationIssueType == null ? 0 : this.analysationIssueType.hashCode());
        result = 31 * result + (this.element == null ? 0 : this.element.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + this.onLine;
        result = 31 * result + (this.severity == null ? 0 : this.severity.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnalysationIssue other = (AnalysationIssue)obj;
        if (this.analysationIssueType != other.analysationIssueType) {
            return false;
        }
        if (this.onLine != other.onLine) {
            return false;
        }
        if (this.severity != other.severity) {
            return false;
        }
        if (this.element == null ? other.element == null : this.element != other.element) {
            return false;
        }
        return !(this.message == null ? other.message != null : !this.message.equals(other.message));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AnalysationIssueSeverity {
        WARNING,
        ERROR;

    }

    public static final class AnalysationIssueType {
        String name;

        public AnalysationIssueType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

