/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.sew.launcher.ui;

import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.efm.sew.launcher.Activator;
import org.eclipse.efm.sew.launcher.ToolConstants;
import org.eclipse.osgi.util.NLS;

public class CoreUtil
implements ToolConstants {
    protected static void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.efm.sew.launcher", code, message, exception));
    }

    public static IPath getLocation(ILaunchConfiguration configuration) throws CoreException {
        String location = null;
        boolean usedDefault = false;
        try {
            usedDefault = configuration.getAttribute("org.eclipse.efm.sew.launcher.ui.ATTR_LAUNCH_AVM_LOCATION_USED_DEFAULT", false);
            location = usedDefault ? Activator.strDiversityAvmExecLocation() : configuration.getAttribute("org.eclipse.efm.sew.launcher.ui.ATTR_LAUNCH_AVM_LOCATION", null);
        }
        catch (CoreException coreException) {}
        if (location == null) {
            try {
                List avmLocation = configuration.getAttribute("org.eclipse.efm.sew.launcher.ui.ATTR_LAUNCH_AVM_LOCATION_HISTORY", null);
                if (avmLocation != null && !avmLocation.isEmpty()) {
                    location = avmLocation.get(0).toString();
                }
            }
            catch (CoreException coreException) {}
        }
        if (location == null) {
            location = Activator.strDiversityAvmExecLocation();
        }
        if (location == null || location.isEmpty()) {
            CoreUtil.abort(NLS.bind((String)"Avm Executable Location not specified by {0}", (Object[])new String[]{configuration.getName()}), null, 0);
        } else {
            String expandedLocation = CoreUtil.getStringVariableManager().performStringSubstitution(location.toString());
            if (expandedLocation == null || expandedLocation.length() == 0) {
                String msg = NLS.bind((String)" The file does not exist for the Avm Executable tool named {0}.", (Object[])new Object[]{configuration.getName()});
                CoreUtil.abort(msg, null, 0);
            } else {
                File file = new File(expandedLocation);
                if (file.isFile()) {
                    return new Path(expandedLocation);
                }
                String msg = NLS.bind((String)" The file does not exist for the Avm Executable tool named {0}.", (Object[])new Object[]{configuration.getName()});
                CoreUtil.abort(msg, null, 0);
            }
        }
        return null;
    }

    public static boolean getCaptureOutput(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.debug.core.capture_output", true);
    }

    public static IPath getWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        String expandedLocation;
        String location = configuration.getAttribute("org.eclipse.efm.sew.launcher.ui.ATTR_WORKING_DIRECTORY", null);
        if (location != null && (expandedLocation = CoreUtil.getStringVariableManager().performStringSubstitution(location)).length() > 0) {
            File path = new File(expandedLocation);
            if (path.isDirectory()) {
                return new Path(expandedLocation);
            }
            String msg = NLS.bind((String)" The working directory {0} does not exist for the external tool named {1}.", (Object[])new Object[]{expandedLocation, configuration.getName()});
            CoreUtil.abort(msg, null, 0);
        }
        return null;
    }

    public static String[] getArguments(ILaunchConfiguration configuration) throws CoreException {
        String args = configuration.getAttribute("org.eclipse.efm.sew.launcher.ui.ATTR_TOOL_ARGUMENTS", null);
        if (args != null) {
            String expanded = CoreUtil.getStringVariableManager().performStringSubstitution(args);
            return CoreUtil.parseStringIntoList(expanded);
        }
        return null;
    }

    private static IStringVariableManager getStringVariableManager() {
        return VariablesPlugin.getDefault().getStringVariableManager();
    }

    public static String[] parseStringIntoList(String arguments) {
        if (arguments == null || arguments.length() == 0) {
            return new String[0];
        }
        String[] res = DebugPlugin.parseArguments((String)arguments);
        return res;
    }
}

