/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.sew.launcher;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.RefreshUtil;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.efm.sew.launcher.Activator;
import org.eclipse.efm.sew.launcher.ui.CoreUtil;
import org.eclipse.efm.sew.launcher.util.BackgroundResourceRefresher;
import org.eclipse.efm.sew.launcher.views.page.LaunchExecConsoleManager;
import org.eclipse.efm.sew.launcher.workflow.IWorkflowConfigurationConstants;
import org.eclipse.efm.sew.launcher.workflow.WorkflowCustomImpl;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class LaunchDelegate2
implements ILaunchConfigurationDelegate,
IWorkflowConfigurationConstants {
    private final String FAVM_TEMPLATE = "resources/sew/template.favm";
    private final String PROJECT_FAVM = "project.favm";
    private final String WORKFLOW_SEW = "workflow.sew";
    private IPath fAvmExecLocation;
    private IProject fProject = null;
    private IPath fFavmLocation = null;
    private IPath fWorkingDirectory = null;
    private String fAnalysisProfile = null;
    public static String fModelAnalysis = "";
    public static boolean fEnableProlongation = false;
    LaunchExecConsoleManager fConsoleManager = new LaunchExecConsoleManager();
    boolean fEnabledDebugOrDeveloperMode = false;
    public static final int ERR_INTERNAL_ERROR = 150;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        boolean bl = this.fEnabledDebugOrDeveloperMode = prefs.getBoolean("org.eclipse.efm.sew.launcher.ui.PREF_DEBUG_OPTIONS") || prefs.getBoolean("org.eclipse.efm.sew.launcher.ui.PREF_SYMBEX_DEVELOPER_MODE");
        if (this.fEnabledDebugOrDeveloperMode) {
            System.out.println("RUN DIVERSITY");
        }
        this.fAvmExecLocation = CoreUtil.getLocation(configuration);
        if (this.fAvmExecLocation != null) {
            this.fProject = this.getCurrentProject(configuration);
            if (this.fProject != null) {
                this.fWorkingDirectory = this.fProject.getLocation();
                WorkflowCustomImpl workflow = WorkflowCustomImpl.create(configuration, this.fWorkingDirectory);
                workflow.toWriter(this.fWorkingDirectory.append("workflow.sew"));
                this.fFavmLocation = this.fWorkingDirectory.append("project.favm");
                this.setModelFile(configuration);
                this.launchExec(configuration, mode, launch, monitor);
            }
        }
    }

    private void setModelFile(ILaunchConfiguration configuration) {
        try {
            String fFolderName;
            int n;
            this.fAnalysisProfile = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_ANALYSIS_PROFILE", "MODEL");
            fModelAnalysis = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_MODEL_ANALYSIS", "");
            Bundle bundle = Platform.getBundle((String)"org.eclipse.efm.sew.launcher");
            URL url = bundle.getEntry("resources/sew/template.favm");
            URL favmTemplateURL = FileLocator.toFileURL((URL)url);
            InputStream inputTemplate = favmTemplateURL.openStream();
            BufferedReader bufferedTemplate = new BufferedReader(new InputStreamReader(inputTemplate));
            StringBuffer buffer = new StringBuffer();
            String line = bufferedTemplate.readLine();
            while (line != null) {
                buffer.append(line);
                buffer.append("\n");
                line = bufferedTemplate.readLine();
            }
            bufferedTemplate.close();
            String favmString = buffer.toString();
            String projectLocation = this.fWorkingDirectory.toString();
            favmString = favmString.replace("__LOCATION_PROJECT__", projectLocation);
            String fModelPath = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_MODEL_FILE_LOCATION", "");
            if (fModelPath.startsWith(projectLocation)) {
                boolean endWidthSeparator = projectLocation.charAt(projectLocation.length() - 1) == '/';
                fModelPath = fModelPath.substring(projectLocation.length() + (endWidthSeparator ? 0 : 1));
            }
            favmString = favmString.replace("__SPECIFICATION_MAIN__", fModelPath);
            int i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_STOP_CRITERIA_NODE", -1);
            favmString = favmString.replace("__NODE__", Integer.toString(i));
            i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_STOP_CRITERIA_WIDTH", -1);
            favmString = favmString.replace("__WIDTH__", Integer.toString(i));
            i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_STOP_CRITERIA_HEIGHT", -1);
            favmString = favmString.replace("__HEIGHT__", Integer.toString(i));
            i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_STOP_CRITERIA_STEPS", -1);
            favmString = favmString.replace("__EVAL__", Integer.toString(i));
            switch (this.fAnalysisProfile) {
                case "MODEL": {
                    switch (fModelAnalysis) {
                        case "Exploration": {
                            favmString = favmString.replace("__EXECUTION_QUEUE_STRATEGY__", configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_ANALYZE_STRATEGY", ""));
                            break;
                        }
                        case "Transition Coverage": {
                            favmString = favmString.replace("__EXECUTION_QUEUE_STRATEGY__", "WEIGHT_BFS");
                            break;
                        }
                        case "Behavior Selection": {
                            String fElementNameListStringField = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BEHAVIOR_ANALYSIS_ELEMENT_NAME_LIST", "");
                            String[] tabString = fElementNameListStringField.trim().split("\\R|;");
                            StringBuffer elementStringList = new StringBuffer();
                            String[] stringArray = tabString;
                            int n2 = tabString.length;
                            n = 0;
                            while (n < n2) {
                                String eltString = stringArray[n];
                                if ((eltString = eltString.trim()).length() != 0) {
                                    if (eltString.startsWith("//")) {
                                        elementStringList.append("\t\t\t\t\t\t").append(eltString).append("\n");
                                    } else {
                                        int pos = eltString.indexOf(61);
                                        if (pos > 0) {
                                            String kind = eltString.substring(0, pos).trim();
                                            String object = eltString.substring(pos + 1).trim();
                                            if (!(kind.equals("transition") || kind.equals("state") || kind.equals("input") || kind.equals("output") || kind.equals("inout"))) {
                                                kind.equals("com");
                                            }
                                            if (object.matches("[^\"'].*\\s+.*[^\"']")) {
                                                object = "\"" + object + "\"";
                                            }
                                            elementStringList.append("\t\t\t\t\t\t@").append(kind).append(" = ").append(object).append(";\n");
                                        } else {
                                            elementStringList.append("\t\t\t\t\t\t@").append(eltString).append(";\n");
                                        }
                                    }
                                }
                                ++n;
                            }
                            if (elementStringList.length() > 0) {
                                favmString = favmString.replace("\t\t\t\t\t\t//__ELEMENT_LIST_TO_COVER__", elementStringList);
                            }
                            favmString = favmString.replace("__EXECUTION_QUEUE_STRATEGY__", "WEIGHT_BFS");
                            break;
                        }
                        default: {
                            favmString = favmString.replace("__EXECUTION_QUEUE_STRATEGY__", configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_ANALYZE_STRATEGY", ""));
                        }
                    }
                    favmString = LaunchDelegate2.suppressProcessString(favmString, "//BEGIN_OFFLINE_TEST_PHASE1", "//END_OFFLINE_TEST_PHASE1");
                    favmString = this.filterRedundancyPhase1(configuration, favmString);
                    break;
                }
                case "TESTOFFLINE": {
                    fModelAnalysis = "";
                    String traceFile = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TRACE_FILE_LOCATION", "<DEFAULT trace file>");
                    favmString = favmString.replace("__TRACE_FILE__", traceFile);
                    String testPurposeFile = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TEST_PURPOSE_FILE_LOCATION", "<test purpose file>");
                    favmString = testPurposeFile.equals("") || testPurposeFile.equals("<test purpose file>") ? favmString.replace("@testPurposeFile", "//__@testPurposeFile") : favmString.replace("__TEST_PURPOSE_FILE__", testPurposeFile);
                    favmString = favmString.replace("__EXECUTION_QUEUE_STRATEGY__", "WEIGHT_BFS");
                    favmString = favmString.replace("//__&process::offline_test", "&process::offline_test");
                    break;
                }
            }
            favmString = this.filterTransitionCoveragePhase1(configuration, favmString);
            favmString = this.processHOJPhase1(configuration, favmString);
            favmString = LaunchDelegate2.suppressProcessString(favmString, "//BEGIN_GRAPH_SLICER_IO_PHASE2", "//END_GRAPH_SLICER_IO_PHASE2");
            if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRACE_ENABLED", false)) {
                favmString = favmString.replace("//__&process::BASIC_trace_generator", "&process::BASIC_trace_generator");
                fFolderName = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRACE_FOLDER_NAME", "Basic");
                favmString = favmString.replace("__BASIC_FOLDER_NAME__", fFolderName);
                String fFileName = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRACE_FILE_NAME", "tests.txt");
                favmString = favmString.replace("__BASIC_FILE_NAME__", fFileName);
                favmString = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRACE_ELIMINATION_REDUNDANCE", true) ? favmString.replace("//__BASIC__@normalize = true;", "@normalize = true;") : favmString.replace("//__BASIC__@normalize = true;", "@normalize = false;");
                boolean enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRACE_TIME_SELECTION", false);
                if (enabled) {
                    favmString = favmString.replace("//__BASIC__@time", "@time");
                }
                if (enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRACE_ALL_EXTERNAL_INPUT_COM_SELECTION", false)) {
                    favmString = favmString.replace("//__BASIC__@input#env", "@input#env");
                }
                if (enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRACE_ALL_EXTERNAL_OUTPUT_COM_SELECTION", false)) {
                    favmString = favmString.replace("//__BASIC__@output#env", "@output#env");
                }
                if (enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRACE_ALL_INPUT_COM_SELECTION", false)) {
                    favmString = favmString.replace("//__BASIC__@input", "@input");
                }
                if (enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRACE_ALL_IOUTPUT_COM_SELECTION", false)) {
                    favmString = favmString.replace("//__BASIC__@output", "@output");
                }
                favmString = (enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRACE_ALL_VARIABLE_SELECTION", false)) ? favmString.replace("//__BASIC__@variable", "@variable") : favmString.replace("//__BASIC__@time", "@time");
                enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRACE_ALL_TRANSITION_SELECTION", false);
                if (enabled) {
                    favmString = favmString.replace("//__BASIC__@transition", "@transition");
                }
                if (enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRACE_ALL_STATE_SELECTION", false)) {
                    favmString = favmString.replace("//__BASIC__@state", "@state");
                }
                String detailsTraceList = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRACE_DETAILS_ELEMENT_LIST", "");
                String[] tabString = detailsTraceList.trim().split(";|\\R");
                StringBuffer detailsStringBuffer = new StringBuffer();
                String[] stringArray = tabString;
                n = tabString.length;
                int n3 = 0;
                while (n3 < n) {
                    String eltString = stringArray[n3];
                    if (!eltString.isEmpty()) {
                        detailsStringBuffer.append("\t\t\t\t\t\t@").append(eltString).append(";\n");
                    }
                    ++n3;
                }
                detailsTraceList = detailsStringBuffer.toString();
                if (!detailsTraceList.isEmpty()) {
                    favmString = favmString.replace("\t\t\t\t\t\t//__DetailsElementsListToTrace", detailsTraceList);
                }
                favmString = favmString.replace("__EXECUTION_QUEUE_STRATEGY__", "WEIGHT_BFS");
            } else {
                favmString = LaunchDelegate2.suppressProcessString(favmString, "//BEGIN_BASIC_TRACE_GENERATOR_PHASE2", "//END_BASIC_TRACE_GENERATOR_PHASE2");
            }
            if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TTCN_ENABLED", false)) {
                favmString = favmString.replace("//__&process::TTCN_trace_generator", "&process::TTCN_trace_generator");
                fFolderName = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TTCN_FOLDER_NAME", "");
                favmString = favmString.replace("__TTCN_FOLDER_NAME__", fFolderName);
            } else {
                favmString = LaunchDelegate2.suppressProcessString(favmString, "//BEGIN_TTCN_TRACE_GENERATOR_PHASE2", "//END_TTCN_TRACE_GENERATOR_PHASE2");
            }
            fEnableProlongation = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_EXTENSION", false);
            if (fEnableProlongation) {
                i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TRACE_EXTENSION_EVALUATION_STEPS", -1);
                favmString = favmString.replace("__EVAL2__", Integer.toString(i));
                favmString = favmString.replace("//__PHASE2_&process::hit_or_jump", "&process::hit_or_jump");
                favmString = favmString.replace("//__&engine::io_continuation", "&engine::io_continuation");
            } else if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRACE_ENABLED", false) || configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TTCN_ENABLED", false)) {
                favmString = favmString.replace("__EVAL2__", "0");
                favmString = LaunchDelegate2.suppressProcessString(favmString, "//BEGIN_HOJ_PHASE2", "//END_HOJ_PHASE2");
                favmString = favmString.replace("//__&engine::io_continuation", "&engine::io_continuation");
            } else {
                favmString = LaunchDelegate2.suppressProcessString(favmString, "//BEGIN_IO_CONTINUATION_PHASE2", "//END_IO_CONTINUATION_PHASE2");
                favmString = favmString.replace("\n\t\t\t//__&engine::io_continuation", "");
            }
            favmString = this.modeDebug(configuration, favmString);
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.fFavmLocation.toFile()));
            writer.write(favmString);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private String filterTransitionCoveragePhase1(ILaunchConfiguration configuration, String currentFavmString) {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        boolean expertMode = prefs.getBoolean("org.eclipse.efm.sew.launcher.ui.PREF_EXPERT_MODE");
        if (this.fAnalysisProfile.equals("MODEL") && fModelAnalysis.equals("Transition Coverage")) {
            try {
                String fTransitionButton = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRANSITION_BUTTON", "All");
                if (fTransitionButton.equals("Details")) {
                    currentFavmString = currentFavmString.replace("__TC1_SCOPE__", "DETAILS");
                    List selectedTransitions = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SELECTED_TRANSITIONS", new ArrayList());
                    StringBuffer TransitionStringList = new StringBuffer();
                    for (String eltString : selectedTransitions) {
                        TransitionStringList.append("\t\t\t\t\t\t@transition = \"").append(eltString).append("\";\n");
                    }
                    currentFavmString = currentFavmString.replace("\t\t\t\t\t\t//__TC1_TransitionListToCover", TransitionStringList.toString());
                }
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
            currentFavmString = currentFavmString.replace("//__PHASE1_&filter::transition_coverage", "&filter::transition_coverage");
            if (expertMode) {
                try {
                    int i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_BEGIN_STEP", 0);
                    currentFavmString = currentFavmString.replace("__TC1_BEGIN_STEP__", Integer.toString(i));
                    boolean b = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_STOP", true);
                    currentFavmString = currentFavmString.replace("__TC1_STOP__", Boolean.toString(b));
                    b = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_MINIMIZE", true);
                    currentFavmString = currentFavmString.replace("__TC1_MINIMIZE__", Boolean.toString(b));
                    b = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_SLICE", true);
                    currentFavmString = currentFavmString.replace("__TC1_SLICE__", Boolean.toString(b));
                    b = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_HEURISTIC", true);
                    currentFavmString = currentFavmString.replace("__TC1_HEURISTIC__", Boolean.toString(b));
                    currentFavmString = currentFavmString.replace("__TC1_SCOPE__", configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_SCOPE", "MODEL"));
                    currentFavmString = currentFavmString.replace("__TC1_HEURISTIC_START__", configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_HEURISTIC_START", "BASIC"));
                    i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_HEURISTIC_TRIALS", -1);
                    currentFavmString = currentFavmString.replace("__TC1_HEURISTIC_TRIALS__", Integer.toString(i));
                    i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_OBJECTIVE_RATE", 100);
                    currentFavmString = currentFavmString.replace("__TC1_OBJECTIVE_RATE__", Integer.toString(i));
                    i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_OBJECTIVE_REST", 0);
                    currentFavmString = currentFavmString.replace("__TC1_OBJECTIVE_REST__", Integer.toString(i));
                    currentFavmString = currentFavmString.replace("__TC1_DIRECTIVE_TRACE_HEURISTIC__", configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_DIRECTIVE_TRACE_HEURISTIC", "SMART"));
                    i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_DIRECTIVE_TRACE_COUNT_LIMIT", 8);
                    currentFavmString = currentFavmString.replace("__TC1_DIRECTIVE_TRACE_COUNT_LIMIT__", Integer.toString(i));
                    i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_DIRECTIVE_TRACE_SIZE_LIMIT", 8);
                    currentFavmString = currentFavmString.replace("__TC1_DIRECTIVE_TRACE_SIZE_LIMIT__", Integer.toString(i));
                    i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_LOOKAHEAD_DEPTH", 7);
                    currentFavmString = currentFavmString.replace("__TC1_COVERAGE_HEIGHT__", Integer.toString(i));
                    i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_LOOKAHEAD_WIDTH", 42);
                    currentFavmString = currentFavmString.replace("__TC1_COVERAGE_HEIGHT_REACHED_LIMIT__", Integer.toString(i));
                    b = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_HIT_STRONGLY_RANDOM", false);
                    currentFavmString = currentFavmString.replace("__TC1_HIT_STRONGLY_RANDOM__", Boolean.toString(b));
                    i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_HIT_STRONGLY_COUNT", 1);
                    currentFavmString = currentFavmString.replace("__TC1_HIT_STRONGLY_COUNT__", Integer.toString(i));
                    b = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_HIT_WEAKLY_RANDOM", false);
                    currentFavmString = currentFavmString.replace("__TC1_HIT_WEAKLY_RANDOM__", Boolean.toString(b));
                    i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_HIT_WEAKLY_COUNT", 1);
                    currentFavmString = currentFavmString.replace("__TC1_HIT_WEAKLY_COUNT__", Integer.toString(i));
                    b = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_HIT_OTHER_RANDOM", false);
                    currentFavmString = currentFavmString.replace("__TC1_HIT_OTHER_RANDOM__", Boolean.toString(b));
                    i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TC_HIT_OTHER_COUNT", 1);
                    currentFavmString = currentFavmString.replace("__TC1_HIT_OTHER_COUNT__", Integer.toString(i));
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            } else {
                currentFavmString = currentFavmString.replace("__TC1_BEGIN_STEP__", "0");
                currentFavmString = currentFavmString.replace("__TC1_STOP__", "true");
                currentFavmString = currentFavmString.replace("__TC1_MINIMIZE__", "true");
                currentFavmString = currentFavmString.replace("__TC1_SLICE__", "true");
                currentFavmString = currentFavmString.replace("__TC1_HEURISTIC__", "true");
                currentFavmString = currentFavmString.replace("__TC1_SCOPE__", "MODEL");
                currentFavmString = currentFavmString.replace("__TC1_HEURISTIC_START__", "BASIC");
                currentFavmString = currentFavmString.replace("__TC1_HEURISTIC_TRIALS__", "7");
                currentFavmString = currentFavmString.replace("__TC1_OBJECTIVE_RATE__", "100");
                currentFavmString = currentFavmString.replace("__TC1_OBJECTIVE_REST__", "0");
                currentFavmString = currentFavmString.replace("__TC1_DIRECTIVE_TRACE_HEURISTIC__", "SMART");
                currentFavmString = currentFavmString.replace("__TC1_DIRECTIVE_TRACE_COUNT_LIMIT__", "8");
                currentFavmString = currentFavmString.replace("__TC1_DIRECTIVE_TRACE_SIZE_LIMIT__", "8");
                currentFavmString = currentFavmString.replace("__TC1_COVERAGE_HEIGHT__", "7");
                currentFavmString = currentFavmString.replace("__TC1_COVERAGE_HEIGHT_REACHED_LIMIT__", "42");
                currentFavmString = currentFavmString.replace("__TC1_HIT_STRONGLY_RANDOM__", "false");
                currentFavmString = currentFavmString.replace("__TC1_HIT_STRONGLY_COUNT__", "1");
                currentFavmString = currentFavmString.replace("__TC1_HIT_WEAKLY_RANDOM__", "false");
                currentFavmString = currentFavmString.replace("__TC1_HIT_WEAKLY_COUNT__", "1");
                currentFavmString = currentFavmString.replace("__TC1_HIT_OTHER_RANDOM__", "false");
                currentFavmString = currentFavmString.replace("__TC1_HIT_OTHER_COUNT__", "1");
            }
        } else {
            currentFavmString = LaunchDelegate2.suppressProcessString(currentFavmString, "//BEGIN_TRANSITION_COVERAGE_PHASE1", "//END_TRANSITION_COVERAGE_PHASE1");
        }
        return currentFavmString;
    }

    private String filterRedundancyPhase1(ILaunchConfiguration configuration, String currentFavmString) {
        try {
            boolean enableInclusion = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_INCLUSION_CRITERION", false);
            currentFavmString = fModelAnalysis.equals("Exploration") && enableInclusion ? currentFavmString.replace("//__PHASE1_&filter::redundancy", "&filter::redundancy") : LaunchDelegate2.suppressProcessString(currentFavmString, "//BEGIN_REDUNDANCY_PHASE1", "//END_REDUNDANCY_PHASE1");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return currentFavmString;
    }

    private String processHOJPhase1(ILaunchConfiguration configuration, String currentFavmString) {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        boolean expertMode = prefs.getBoolean("org.eclipse.efm.sew.launcher.ui.PREF_EXPERT_MODE");
        if (this.fAnalysisProfile.equals("MODEL") && fModelAnalysis.equals("Behavior Selection")) {
            currentFavmString = currentFavmString.replace("//__PHASE1_&process::hit_or_jump", "&process::hit_or_jump");
            if (expertMode) {
                try {
                    int i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_BEGIN_STEP", 0);
                    currentFavmString = currentFavmString.replace("__HOJ1_BEGIN_STEP__", Integer.toString(i));
                    boolean b = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_HEURISTIC", true);
                    currentFavmString = currentFavmString.replace("__HOJ1_HEURISTIC__", Boolean.toString(b));
                    b = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_STOP", true);
                    currentFavmString = currentFavmString.replace("__HOJ1_STOP__", Boolean.toString(b));
                    b = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_SLICE", true);
                    currentFavmString = currentFavmString.replace("__HOJ1_SLICE__", Boolean.toString(b));
                    currentFavmString = currentFavmString.replace("__HOJ1_SEARCH_SCOPE__", configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_SEARCH_SCOPE", "LOCALLY"));
                    i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_JUMP_HEIGHT", 6);
                    currentFavmString = currentFavmString.replace("__HOJ1_JUMP_HEIGHT__", Integer.toString(i));
                    i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_JUMP_TRIALS_LIMIT", 2);
                    currentFavmString = currentFavmString.replace("__HOJ1_JUMP_LIMIT__", Integer.toString(i));
                    i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_HIT_COUNT", 1);
                    currentFavmString = currentFavmString.replace("__HOJ1_HIT_COUNT__", Integer.toString(i));
                    b = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_HIT_CONSECUTIVE", false);
                    currentFavmString = currentFavmString.replace("__HOJ1_HIT_CONSECUTIVE__", Boolean.toString(b));
                    b = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_HIT_MAX", false);
                    currentFavmString = currentFavmString.replace("__HOJ1_HIT_MAX__", Boolean.toString(b));
                    i = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_JUMP_COUNT", 1);
                    currentFavmString = currentFavmString.replace("__HOJ1_JUMP_COUNT__", Integer.toString(i));
                    b = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_JUMP_SLICE", false);
                    currentFavmString = currentFavmString.replace("__HOJ1_JUMP_SLICE__", Boolean.toString(b));
                    b = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_HOJ_SCHEDULER_ORDERED", true);
                    currentFavmString = currentFavmString.replace("__HOJ1_SCHEDULER__", b ? "|;|" : "|i|");
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            } else {
                currentFavmString = currentFavmString.replace("__HOJ1_BEGIN_STEP__", "0");
                currentFavmString = currentFavmString.replace("__HOJ1_HEURISTIC__", "true");
                currentFavmString = currentFavmString.replace("__HOJ1_STOP__", "true");
                currentFavmString = currentFavmString.replace("__HOJ1_SLICE__", "true");
                currentFavmString = currentFavmString.replace("__HOJ1_SEARCH_SCOPE__", "LOCALLY");
                currentFavmString = currentFavmString.replace("__HOJ1_JUMP_HEIGHT__", "6");
                currentFavmString = currentFavmString.replace("__HOJ1_JUMP_LIMIT__", "2");
                currentFavmString = currentFavmString.replace("__HOJ1_HIT_COUNT__", "1");
                currentFavmString = currentFavmString.replace("__HOJ1_HIT_CONSECUTIVE__", "false");
                currentFavmString = currentFavmString.replace("__HOJ1_HIT_MAX__", "false");
                currentFavmString = currentFavmString.replace("__HOJ1_JUMP_COUNT__", "1");
                currentFavmString = currentFavmString.replace("__HOJ1_JUMP_SLICE__", "false");
                currentFavmString = currentFavmString.replace("__HOJ1_SCHEDULER__", "|;|");
            }
        } else {
            currentFavmString = LaunchDelegate2.suppressProcessString(currentFavmString, "//BEGIN_HOJ_PHASE1", "//END_HOJ_PHASE1");
        }
        return currentFavmString;
    }

    private String modeDebug(ILaunchConfiguration configuration, String currentFavmString) {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        boolean debugOptionMode = prefs.getBoolean("org.eclipse.efm.sew.launcher.ui.PREF_DEBUG_OPTIONS");
        if (debugOptionMode) {
            try {
                if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_FIRST_PARSED_MODEL_GRAPHVIZ_GENERATION", false)) {
                    currentFavmString = currentFavmString.replace("//__@file_statemachine_graph", "@file");
                    currentFavmString = currentFavmString.replace("//__PHASE1_&processor::serializer#statemachine", "&processor::serializer#statemachine");
                } else {
                    currentFavmString = LaunchDelegate2.suppressProcessString(currentFavmString, "//BEGIN_SERIALIZER_STATEMACHINE_PHASE1", "//END_SERIALIZER_STATEMACHINE_PHASE1");
                }
                if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_FIRST_SYMBEX_OUTPUT_GRAPHVIZ_GENERATION", false)) {
                    currentFavmString = currentFavmString.replace("//__@file_phase1_execution_graph", "@file");
                    currentFavmString = currentFavmString.replace("//__PHASE1_&processor::serializer#execution_graph", "&processor::serializer#execution_graph");
                } else {
                    currentFavmString = LaunchDelegate2.suppressProcessString(currentFavmString, "//BEGIN_SERIALIZER_EXECUTION_GRAPH_PHASE1", "//END_SERIALIZER_EXECUTION_GRAPH_PHASE1");
                }
                if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_SECOND_SYMBEX_OUTPUT_GRAPHVIZ_GENERATION", false)) {
                    currentFavmString = currentFavmString.replace("//__@file_phase2_execution_graph", "@file");
                    currentFavmString = currentFavmString.replace("//__PHASE2_&processor::serializer#execution_graph", "&processor::serializer#execution_graph");
                } else if (fEnableProlongation) {
                    currentFavmString = LaunchDelegate2.suppressProcessString(currentFavmString, "//BEGIN_SERIALIZER_EXECUTION_GRAPH_PHASE2", "//END_SERIALIZER_EXECUTION_GRAPH_PHASE2");
                }
                currentFavmString = currentFavmString.replace("__CONSOLE_TRACE_LEVEL__", configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_CONSOLE_LOG_VERBOSE_LEVEL", "MINIMUM"));
                if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_DEVELOPER_TUNING", false)) {
                    currentFavmString = currentFavmString.replace("//__@log =", "@log =");
                    currentFavmString = currentFavmString.replace("__AVM_LOG__", configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_DEVELOPER_TUNING_LOG_FILENAME", "avm.log"));
                    currentFavmString = currentFavmString.replace("//__@debug =", "@debug =");
                    currentFavmString = currentFavmString.replace("__AVM_TRACE__", configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_DEVELOPER_TUNING_DEBUG_FILENAME", "avm.trace"));
                    currentFavmString = currentFavmString.replace("__TRACE_LEVEL__", configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_DEVELOPER_TUNING_DEBUG_LEVEL", "LOW"));
                    if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_PARSING", false)) {
                        currentFavmString = currentFavmString.replace("//__@kind = 'PARSING';", "@kind = 'PARSING';");
                    }
                    if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_COMPILING", false)) {
                        currentFavmString = currentFavmString.replace("//__@kind = 'COMPILING';", "@kind = 'COMPILING';");
                    }
                    if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_COMPUTING", false)) {
                        currentFavmString = currentFavmString.replace("//__@kind = 'COMPUTING';", "@kind = 'COMPUTING';");
                    }
                    if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_ALL_PROCESS_STAGE", false)) {
                        currentFavmString = currentFavmString.replace("//__@kind = 'ALL_PROCESS_STAGE';", "@kind = 'ALL_PROCESS_STAGE';");
                    }
                    if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_PROGRAM", false)) {
                        currentFavmString = currentFavmString.replace("//__@kind = 'PROGRAM';", "@kind = 'PROGRAM';");
                    }
                    if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_STATEMENT_ASSIGNMENT", false)) {
                        currentFavmString = currentFavmString.replace("//__@kind = 'STMNT_ASSIGN';", "@kind = 'STMNT_ASSIGN';");
                    }
                    if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_STATEMENT", false)) {
                        currentFavmString = currentFavmString.replace("//__@kind = 'STATEMENT';", "@kind = 'STATEMENT';");
                    }
                    if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_BYTECODE", false)) {
                        currentFavmString = currentFavmString.replace("//__@kind = 'BYTECODE';", "@kind = 'BYTECODE';");
                    }
                    if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_STATEMENT_COMMUNICATION", false)) {
                        currentFavmString = currentFavmString.replace("//__@kind = 'STMNT_COM';", "@kind = 'STMNT_COM';");
                    }
                    if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_SOLVING", false)) {
                        currentFavmString = currentFavmString.replace("//__@kind = 'SOLVING';", "@kind = 'SOLVING';");
                    }
                    if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_DATA", false)) {
                        currentFavmString = currentFavmString.replace("//__@kind = 'DATA';", "@kind = 'DATA';");
                    }
                    if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_REPORTING", false)) {
                        currentFavmString = currentFavmString.replace("//__@kind = 'REPORTING';", "@kind = 'REPORTING';");
                    }
                    if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_CONFIGURING", false)) {
                        currentFavmString = currentFavmString.replace("//__@kind = 'CONFIGURING';", "@kind = 'CONFIGURING';");
                    }
                    if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_REDUNDANCE", false)) {
                        currentFavmString = currentFavmString.replace("//__@kind = 'REDUNDANCE';", "@kind = 'REDUNDANCE';");
                    }
                    if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_TRACE", false)) {
                        currentFavmString = currentFavmString.replace("//__@kind = 'TRACE';", "@kind = 'TRACE';");
                    }
                } else {
                    currentFavmString = currentFavmString.replace("__TRACE_LEVEL__", "ZERO");
                }
                if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_FIRST_COMPILED_MODEL_TEXTUAL_GENERATION", false)) {
                    currentFavmString = currentFavmString.replace("//__PHASE1_@executable =", "@executable =");
                    currentFavmString = currentFavmString.replace("__PHASE1_EXE__", configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_FIRST_COMPILED_MODEL_TEXTUAL_FILENAME", "phase1.fexe"));
                }
                if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_FIRST_SYMBEX_OUTPUT_TEXTUAL_GENERATION", false)) {
                    currentFavmString = currentFavmString.replace("//__PHASE1_@scenarii =", "@scenarii =");
                    currentFavmString = currentFavmString.replace("__PHASE1_FSCN__", configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_FIRST_SYMBEX_OUTPUT_TEXTUAL_FILENAME", "symbex_output.fscn"));
                }
                if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_SECOND_COMPILED_MODEL_TEXTUAL_GENERATION", false)) {
                    currentFavmString = currentFavmString.replace("//__PHASE2_@executable =", "@executable =");
                    currentFavmString = currentFavmString.replace("__PHASE2_EXE__", configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_SECOND_COMPILED_MODEL_TEXTUAL_GENERATION", "phase2.fexe"));
                }
                if (configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_SECOND_SYMBEX_OUTPUT_TEXTUAL_GENERATION", false)) {
                    currentFavmString = currentFavmString.replace("//__PHASE2_@scenarii =", "@scenarii =");
                    currentFavmString = currentFavmString.replace("__PHASE2_FSCN__", configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SECOND_SYMBEX_OUTPUT_TEXTUAL_FILENAME", "phase2.fscn"));
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else {
            currentFavmString = currentFavmString.replace("__CONSOLE_TRACE_LEVEL__", "MINIMUM");
            currentFavmString = currentFavmString.replace("__TRACE_LEVEL__", "ZERO");
        }
        return currentFavmString;
    }

    private static String suppressProcessString(String input, String beginString, String endString) {
        int firstPos = input.indexOf(beginString);
        int lastPos = input.indexOf(endString) + endString.length() + 2;
        String result = String.valueOf(input.substring(0, firstPos)) + input.substring(lastPos, input.length());
        return result;
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "org.eclipse.efm.sew.launcher", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public IProject getCurrentProject(ILaunchConfiguration configuration) throws CoreException {
        IProject project;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String projectName = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_PROJECT_NAME", "");
        if (projectName != null && !projectName.isEmpty() && (project = root.getProject(projectName)) != null) {
            return project;
        }
        String aLocation = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_MODEL_FILE_LOCATION", "");
        if (aLocation == null || aLocation.isEmpty()) {
            this.throwCoreException("The model file does not exist.");
            return null;
        }
        IResource resource = root.findMember(aLocation);
        if (resource == null || !resource.exists()) {
            this.throwCoreException("The ressource model file \"" + aLocation + "\" does not exist.");
            return null;
        }
        return resource.getProject();
    }

    public void launchExec(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        if (monitor.isCanceled()) {
            return;
        }
        String[] arguments = CoreUtil.getArguments(configuration);
        if (monitor.isCanceled()) {
            return;
        }
        int cmdLineLength = 2 + (arguments != null ? arguments.length : 0);
        String[] cmdLine = new String[cmdLineLength];
        cmdLine[0] = this.fAvmExecLocation.toOSString();
        cmdLine[1] = this.fFavmLocation.toOSString();
        if (arguments != null) {
            System.arraycopy(arguments, 0, cmdLine, 1, arguments.length);
        }
        if (monitor.isCanceled()) {
            return;
        }
        String[] envp = DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
        if (monitor.isCanceled()) {
            return;
        }
        File workingDir = this.fWorkingDirectory != null ? this.fWorkingDirectory.toFile() : null;
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        boolean debugOptionMode = prefs.getBoolean("org.eclipse.efm.sew.launcher.ui.PREF_DEBUG_OPTIONS");
        String consoleLevel = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_CONSOLE_LOG_VERBOSE_LEVEL", "MINIMUM");
        boolean spiderView = prefs.getBoolean("org.eclipse.efm.sew.launcher.ui.PREF_SPIDER_VIEW");
        boolean consoleView = prefs.getBoolean("org.eclipse.efm.sew.launcher.ui.PREF_CONSOLE_VIEW");
        if (spiderView && (!debugOptionMode || consoleLevel.equals("MINIMUM"))) {
            this.fConsoleManager.sewLaunchExecProcess(configuration, mode, launch, monitor, cmdLine, workingDir, envp);
        } else if (consoleView) {
            this.defaultLaunchExecProcess(configuration, mode, launch, monitor, cmdLine, workingDir, envp);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void defaultLaunchExecProcess(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor, String[] cmdLine, File workingDir, String[] envp) throws CoreException {
        block12: {
            javaProcess = DebugPlugin.exec((String[])cmdLine, (File)workingDir, (String[])envp);
            eclipseProcess = null;
            processAttributes = new HashMap<String, String>();
            programName = this.fAvmExecLocation.lastSegment();
            extension = this.fAvmExecLocation.getFileExtension();
            if (extension != null) {
                programName = programName.substring(0, programName.length() - (extension.length() + 1));
            }
            programName = programName.toLowerCase();
            processAttributes.put(IProcess.ATTR_PROCESS_TYPE, programName);
            if (javaProcess != null) {
                monitor.beginTask(NLS.bind((String)"Running {0}...", (Object[])new String[]{configuration.getName()}), -1);
                fStopavmLocation = this.getCurrentProject(configuration).getLocation().append("Output/log/stop.avm");
                fStopavmFile = fStopavmLocation.toFile();
                fStopavmFile.delete();
                eclipseProcess = DebugPlugin.newProcess((ILaunch)launch, (Process)javaProcess, (String)this.fAvmExecLocation.toOSString(), processAttributes);
            }
            if (javaProcess == null || eclipseProcess == null) {
                if (javaProcess != null) {
                    javaProcess.destroy();
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.efm.sew.launcher", 150, "An IProcess could not be created for the launch", null));
            }
            eclipseProcess.setAttribute(IProcess.ATTR_CMDLINE, this.generateCommandLine(cmdLine));
            if (!configuration.getAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", true)) ** GOTO lbl37
            scope = configuration.getAttribute(RefreshUtil.ATTR_REFRESH_SCOPE, null);
            if (scope == null) break block12;
            refresher = new BackgroundResourceRefresher(configuration, eclipseProcess);
            refresher.startBackgroundRefresh();
            break block12;
lbl-1000:
            // 1 sources

            {
                try {
                    if (monitor.isCanceled()) {
                        eclipseProcess.terminate();
                        break;
                    }
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
lbl37:
                // 3 sources

                ** while (!eclipseProcess.isTerminated())
            }
lbl38:
            // 2 sources

            RefreshUtil.refreshResources((ILaunchConfiguration)configuration, (IProgressMonitor)monitor);
        }
        if ((timeout = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_STOP_CRITERIA_TIMEOUT", -1)) != -1) {
            this.launchSupervisor(configuration, javaProcess, timeout);
        }
    }

    protected void launchSupervisor(ILaunchConfiguration configuration, Process javaProcess, int timeout) {
        try {
            javaProcess.waitFor(timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (javaProcess.isAlive()) {
            try {
                IPath fStopavmLocation = this.getCurrentProject(configuration).getLocation().append("Output/log/stop.avm");
                BufferedWriter stopavm = new BufferedWriter(new FileWriter(fStopavmLocation.toFile()));
                stopavm.write("");
                stopavm.close();
            }
            catch (IOException iOException) {
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            System.out.println("TIMEOUT END");
        }
    }

    private String generateCommandLine(String[] commandLine) {
        if (commandLine.length < 1) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < commandLine.length) {
            buf.append(' ');
            char[] characters = commandLine[i].toCharArray();
            StringBuffer command = new StringBuffer();
            boolean containsSpace = false;
            int j = 0;
            while (j < characters.length) {
                char character = characters[j];
                if (character == '\"') {
                    command.append('\\');
                } else if (character == ' ') {
                    containsSpace = true;
                }
                command.append(character);
                ++j;
            }
            if (containsSpace) {
                buf.append('\"');
                buf.append(command);
                buf.append('\"');
            } else {
                buf.append(command);
            }
            ++i;
        }
        return buf.toString();
    }
}

