/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.IsValueExpression;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class RegexpExpression
extends Expression_Value {
    private static final String CANNOT_DETERMINE_ARG_TYPE = "Cannot determine the argument type of `regexp' operation";
    private static final String OPERANDERROR1 = "The first operand of the `regexp' operation should be a (universal) charstring value";
    private static final String OPERANDERROR2 = "The second operand of the `regexp' operation should be a charstring value";
    private static final String OPERANDERROR3 = "The third operand of the `regexp' operation should be an integer value";
    private static final String OPERANDERROR4 = "The third operand of operation `regexp' should not be negative";
    private static final String OPERANDERROR5 = "Using a large integer value ({0}) as the third operand of operation `regexp'' is not allowed";
    private final TemplateInstance templateInstance1;
    private final TemplateInstance templateInstance2;
    private final Value value3;

    public RegexpExpression(TemplateInstance templateInstance1, TemplateInstance templateInstance2, Value value3) {
        this.templateInstance1 = templateInstance1;
        this.templateInstance2 = templateInstance2;
        this.value3 = value3;
        if (templateInstance1 != null) {
            templateInstance1.setFullNameParent(this);
        }
        if (templateInstance2 != null) {
            templateInstance2.setFullNameParent(this);
        }
        if (value3 != null) {
            value3.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.REGULAREXPRESSION_OPERATION;
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder("regexp(");
        builder.append(this.templateInstance1.createStringRepresentation());
        builder.append(", ");
        builder.append(this.templateInstance2.createStringRepresentation());
        builder.append(", ");
        builder.append(this.value3.createStringRepresentation());
        builder.append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.templateInstance1 != null) {
            this.templateInstance1.setMyScope(scope);
        }
        if (this.templateInstance2 != null) {
            this.templateInstance2.setMyScope(scope);
        }
        if (this.value3 != null) {
            this.value3.setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.templateInstance1 == child) {
            return builder.append(".<operand1>");
        }
        if (this.templateInstance2 == child) {
            return builder.append(".<operand2>");
        }
        if (this.value3 == child) {
            return builder.append(".<operand3>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        IValue last = this.getValueRefdLast(timestamp, expectedValue, null);
        if (last == null || this.templateInstance1 == null) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        if (last.getIsErroneous(timestamp)) {
            this.setIsErroneous(true);
            return IType.Type_type.TYPE_UNDEFINED;
        }
        ITTCN3Template template = this.templateInstance1.getTemplateBody().setLoweridToReference(timestamp);
        IType.Type_type tempType = template.getExpressionReturntype(timestamp, Expected_Value_type.EXPECTED_TEMPLATE);
        switch (tempType) {
            case TYPE_CHARSTRING: 
            case TYPE_UCHARSTRING: {
                return tempType;
            }
            case TYPE_UNDEFINED: {
                return tempType;
            }
        }
        this.setIsErroneous(true);
        return IType.Type_type.TYPE_UNDEFINED;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return true;
    }

    @Override
    public IValue setLoweridToReference(CompilationTimeStamp timestamp) {
        if (this.templateInstance1 != null && this.templateInstance1.getType() != null && this.templateInstance1.getDerivedReference() != null) {
            this.templateInstance1.getTemplateBody().setLoweridToReference(timestamp);
        }
        if (this.templateInstance2 != null && this.templateInstance2.getType() != null && this.templateInstance2.getDerivedReference() != null) {
            this.templateInstance2.getTemplateBody().setLoweridToReference(timestamp);
        }
        return this;
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        ITTCN3Template temp;
        Expected_Value_type internalExpectation = Expected_Value_type.EXPECTED_DYNAMIC_VALUE.equals((Object)expectedValue) ? Expected_Value_type.EXPECTED_TEMPLATE : expectedValue;
        this.setIsErroneous(false);
        if (this.templateInstance1 != null) {
            IType governor1 = this.templateInstance1.getExpressionGovernor(timestamp, internalExpectation);
            if (governor1 == null) {
                temp = this.templateInstance1.getTemplateBody().setLoweridToReference(timestamp);
                governor1 = temp.getExpressionGovernor(timestamp, internalExpectation);
            }
            if (governor1 == null) {
                this.templateInstance1.getLocation().reportSemanticError(CANNOT_DETERMINE_ARG_TYPE);
                this.setIsErroneous(true);
                return;
            }
            IsValueExpression.checkExpressionTemplateInstance(timestamp, this, this.templateInstance1, governor1, referenceChain, expectedValue);
            if (this.getIsErroneous(timestamp)) {
                return;
            }
            temp = this.templateInstance1.getTemplateBody().setLoweridToReference(timestamp);
            temp.checkSpecificValue(timestamp, false);
            switch (governor1.getTypeRefdLast(timestamp).getTypetypeTtcn3()) {
                case TYPE_CHARSTRING: 
                case TYPE_UCHARSTRING: {
                    break;
                }
                case TYPE_UNDEFINED: {
                    this.setIsErroneous(true);
                    break;
                }
                default: {
                    this.location.reportSemanticError(OPERANDERROR1);
                    this.setIsErroneous(true);
                }
            }
        }
        if (this.templateInstance2 != null) {
            IType governor2 = this.templateInstance2.getExpressionGovernor(timestamp, internalExpectation);
            if (governor2 == null) {
                temp = this.templateInstance2.getTemplateBody().setLoweridToReference(timestamp);
                governor2 = temp.getExpressionGovernor(timestamp, internalExpectation);
            }
            if (governor2 == null) {
                this.templateInstance2.getLocation().reportSemanticError(CANNOT_DETERMINE_ARG_TYPE);
                this.setIsErroneous(true);
                return;
            }
            IsValueExpression.checkExpressionTemplateInstance(timestamp, this, this.templateInstance2, governor2, referenceChain, expectedValue);
            if (this.getIsErroneous(timestamp)) {
                return;
            }
            switch (governor2.getTypeRefdLast(timestamp).getTypetype()) {
                case TYPE_CHARSTRING: {
                    break;
                }
                case TYPE_UNDEFINED: {
                    this.setIsErroneous(true);
                    break;
                }
                default: {
                    this.location.reportSemanticError(OPERANDERROR2);
                    this.setIsErroneous(true);
                }
            }
        }
        if (this.value3 != null) {
            IValue temp2 = this.value3.setLoweridToReference(timestamp);
            IType.Type_type tempType3 = temp2.getExpressionReturntype(timestamp, expectedValue);
            switch (tempType3) {
                case TYPE_INTEGER: {
                    IValue last3 = temp2.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    if (last3.isUnfoldable(timestamp) || !IValue.Value_type.INTEGER_VALUE.equals((Object)last3.getValuetype())) break;
                    if (((Integer_Value)last3).isNative()) {
                        long i = ((Integer_Value)last3).getValue();
                        if (i >= 0L) break;
                        this.value3.getLocation().reportSemanticError(OPERANDERROR4);
                        this.setIsErroneous(true);
                        break;
                    }
                    this.value3.getLocation().reportSemanticError(MessageFormat.format(OPERANDERROR5, last3));
                    this.setIsErroneous(true);
                    break;
                }
                case TYPE_UNDEFINED: {
                    this.setIsErroneous(true);
                    break;
                }
                default: {
                    this.location.reportSemanticError(OPERANDERROR3);
                    this.setIsErroneous(true);
                }
            }
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.templateInstance1 == null || this.templateInstance2 == null || this.value3 == null) {
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        if (this.getIsErroneous(timestamp)) {
            return this.lastValue;
        }
        if (this.isUnfoldable(timestamp, referenceChain)) {
            return this.lastValue;
        }
        return this.lastValue;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            if (this.templateInstance1 != null) {
                referenceChain.markState();
                this.templateInstance1.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
            if (this.templateInstance2 != null) {
                referenceChain.markState();
                this.templateInstance2.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
            if (this.value3 != null) {
                referenceChain.markState();
                this.value3.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.templateInstance1 != null) {
            this.templateInstance1.updateSyntax(reparser, false);
            reparser.updateLocation(this.templateInstance1.getLocation());
        }
        if (this.templateInstance2 != null) {
            this.templateInstance2.updateSyntax(reparser, false);
            reparser.updateLocation(this.templateInstance2.getLocation());
        }
        if (this.value3 != null) {
            this.value3.updateSyntax(reparser, false);
            reparser.updateLocation(this.value3.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.templateInstance1 != null) {
            this.templateInstance1.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.templateInstance2 != null) {
            this.templateInstance2.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.value3 != null) {
            this.value3.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.templateInstance1 != null && !this.templateInstance1.accept(v)) {
            return false;
        }
        if (this.templateInstance2 != null && !this.templateInstance2.accept(v)) {
            return false;
        }
        return this.value3 == null || this.value3.accept(v);
    }
}

