/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ControlPart;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Definition_Statement
extends Statement {
    private static final String FULLNAMEPART = ".def";
    private static final String STATEMENT_NAME = "definition";
    private final Definition definition;
    private Definition myDefinition;

    public Definition_Statement(Definition definition) {
        this.definition = definition;
        if (definition != null) {
            definition.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_DEF;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.definition == child) {
            return builder.append(FULLNAMEPART);
        }
        return builder;
    }

    public Definition getDefinition() {
        return this.definition;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.definition != null) {
            this.definition.setMyScope(scope);
        }
    }

    @Override
    public void setMyDefinition(Definition definition) {
        this.myDefinition = definition;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        if (this.definition != null) {
            if (this.myDefinition == null) {
                ControlPart controlPart = this.myScope.getControlPart();
                if (controlPart != null) {
                    this.definition.setAttributeParentPath(controlPart.getAttributePath());
                }
            } else {
                this.definition.setAttributeParentPath(this.myDefinition.getAttributePath());
            }
            this.definition.check(timestamp);
            if (this.myStatementBlock != null) {
                this.myStatementBlock.registerDefinition(timestamp, this.definition);
            }
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void postCheck() {
        if (this.definition != null) {
            this.definition.postCheck();
        }
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        if (this.definition != null) {
            return this.definition.getPossibleExtensionStarterTokens();
        }
        return new ArrayList<Integer>(0);
    }

    @Override
    public List<Integer> getPossiblePrefixTokens() {
        if (this.definition != null) {
            return this.definition.getPossiblePrefixTokens();
        }
        return new ArrayList<Integer>(0);
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.definition != null) {
            this.definition.updateSyntax(reparser, false);
            reparser.updateLocation(this.definition.getLocation());
            if (!this.definition.getLocation().equals(this.definition.getCumulativeDefinitionLocation())) {
                reparser.updateLocation(this.definition.getCumulativeDefinitionLocation());
            }
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.definition != null) {
            this.definition.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.definition == null || this.definition.accept(v);
    }
}

