/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import net.claribole.zgrviewer.ConfigManager;
import net.claribole.zgrviewer.GraphicsManager;

public class ZGRGlassPane
extends JComponent {
    private static final long serialVersionUID = 1L;
    static final int BAR_WIDTH = 200;
    static final int BAR_HEIGHT = 10;
    static final AlphaComposite GLASS_ALPHA = AlphaComposite.getInstance(3, 0.65f);
    static final Color MSG_COLOR = Color.DARK_GRAY;
    GradientPaint PROGRESS_GRADIENT = new GradientPaint(0.0f, 0.0f, Color.ORANGE, 0.0f, 10.0f, Color.BLUE);
    String msg = "";
    int msgX = 0;
    int msgY = 0;
    int completion = 0;
    int prX = 0;
    int prY = 0;
    int prW = 0;
    GraphicsManager grMngr;

    ZGRGlassPane(GraphicsManager grMngr) {
        this.grMngr = grMngr;
        this.addMouseListener(new MouseAdapter(){});
        this.addMouseMotionListener(new MouseMotionAdapter(){});
        this.addKeyListener(new KeyAdapter(){});
    }

    void setProgress(int c) {
        this.completion = c;
        this.prX = this.grMngr.panelWidth / 2 - 100;
        this.prY = this.grMngr.panelHeight / 2 - 5;
        this.prW = (int)(200.0f * (float)this.completion / 100.0f);
        this.PROGRESS_GRADIENT = new GradientPaint(0.0f, this.prY, Color.LIGHT_GRAY, 0.0f, this.prY + 10, Color.DARK_GRAY);
        this.repaint(this.prX, this.prY, 200, 10);
    }

    void setMessage(String m) {
        this.msg = m;
        this.msgX = this.grMngr.panelWidth / 2 - 100;
        this.msgY = this.grMngr.panelHeight / 2 - 5 - 10;
        this.repaint(this.msgX, this.msgY - 50, 200, 70);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Rectangle clip = g.getClipBounds();
        g2.setComposite(GLASS_ALPHA);
        g2.setColor(Color.WHITE);
        g2.fillRect(clip.x, clip.y, clip.width, clip.height);
        g2.setComposite(AlphaComposite.Src);
        if (this.msg != "") {
            g2.setColor(MSG_COLOR);
            g2.setFont(ConfigManager.defaultFont);
            g2.drawString(this.msg, this.msgX, this.msgY);
        }
        g2.setPaint(this.PROGRESS_GRADIENT);
        g2.fillRect(this.prX, this.prY, this.prW, 10);
        g2.setColor(MSG_COLOR);
        g2.drawRect(this.prX, this.prY, 200, 10);
    }
}

