/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.context;

import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.maven.index.creator.JarFileContentsIndexCreator;

public class NexusAnalyzer
extends Analyzer {
    public TokenStream tokenStream(String fieldName, Reader reader) {
        return this.getTokenizer(fieldName, reader);
    }

    protected Tokenizer getTokenizer(String fieldName, Reader reader) {
        if (JarFileContentsIndexCreator.FLD_CLASSNAMES_KW.getKey().equals(fieldName)) {
            return new DeprecatedClassnamesTokenizer(reader);
        }
        return new LetterOrDigitTokenizer(reader);
    }

    public static class LetterOrDigitTokenizer
    extends CharTokenizer {
        public LetterOrDigitTokenizer(Reader in) {
            super(in);
        }

        protected boolean isTokenChar(char c) {
            return Character.isLetterOrDigit(c);
        }

        protected char normalize(char c) {
            return Character.toLowerCase(c);
        }
    }

    @Deprecated
    public static class DeprecatedClassnamesTokenizer
    extends CharTokenizer {
        public DeprecatedClassnamesTokenizer(Reader in) {
            super(in);
        }

        protected boolean isTokenChar(char c) {
            return c != '\n';
        }

        protected char normalize(char c) {
            return Character.toLowerCase(c);
        }
    }

    public static class NoopTokenizer
    extends CharTokenizer {
        public NoopTokenizer(Reader in) {
            super(in);
        }

        protected boolean isTokenChar(char c) {
            return true;
        }
    }
}

