/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.msc.ui.core;

import java.awt.Rectangle;
import java.util.Comparator;
import org.eclipse.titan.log.viewer.views.msc.ui.view.IGC;

public abstract class MSCNode {
    private String name = "";
    protected int eventOccurrence;

    protected MSCNode(int eventOccurrence) {
        this.eventOccurrence = eventOccurrence;
    }

    public void setName(String nodeName) {
        this.name = nodeName;
    }

    public String getName() {
        return this.name;
    }

    public boolean contains(int x, int y) {
        return new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight()).contains(x, y);
    }

    public abstract int getX();

    public abstract int getY();

    public abstract int getHeight();

    public abstract int getWidth();

    protected abstract void draw(IGC var1);

    boolean isVisible(int x, int y, int width, int height) {
        return MSCNode.isVisibleRectange(this, x, y, width, height);
    }

    public Comparator<MSCNode> getComparator() {
        return null;
    }

    public Comparator<MSCNode> getBackComparator() {
        return null;
    }

    public abstract Type getType();

    public boolean positiveDistanceToPoint(int x, int y) {
        return false;
    }

    public int getStartOccurrence() {
        return this.eventOccurrence;
    }

    public int getEndOccurrence() {
        return this.eventOccurrence;
    }

    public static boolean contains(int x, int y, int width, int height, int px, int py) {
        int locX = x;
        int locY = y;
        int locWidth = width;
        int locHeight = height;
        if (width < 0) {
            locX += width;
            locWidth = -locWidth;
        }
        if (height < 0) {
            locY += height;
            locHeight = -locHeight;
        }
        return px >= locX && py >= locY && px - locX <= locWidth && py - locY <= locHeight;
    }

    protected static boolean isVisibleRectange(MSCNode node, int vx, int vy, int vwidth, int vheight) {
        int x = node.getX();
        int y = node.getY();
        int width = node.getWidth();
        int height = node.getHeight();
        return x + width >= vx && x <= vx + vwidth && y + height >= vy && y <= vy + vheight;
    }

    protected static enum Type {
        LIFE_LINE(0),
        COMPONENT_CREATION(1),
        COMPONENT_TERMINATION(2),
        ENQUEUED(3),
        FUNCTION(4),
        FUNCTION_DONE(5),
        PORT_CONNECTION(6),
        PORT_DISCONNECTED(7),
        PORT_MAPPING(8),
        PORT_UNMAPPING(9),
        SETVERDICT_COMPONENT(10),
        SETVERDICT_UNKNOWN(11),
        SIGNAL(12),
        SILENT_EVENT(13),
        TESTCASE_END(14),
        TESTCASE_START(15),
        TIMESTAMP(16),
        LIFE_LINE_HEADER(17);

        private final Integer zOrder;
        public static final Comparator<Type> Z_ORDER_COMPARATOR;

        private Type(int order) {
            this.zOrder = order;
        }

        public Integer getZOrder() {
            return this.zOrder;
        }

        static {
            Z_ORDER_COMPARATOR = new Comparator<Type>(){

                @Override
                public int compare(Type o1, Type o2) {
                    return o1.zOrder - o2.zOrder;
                }
            };
        }
    }
}

