/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.titan.log.viewer.Activator;
import org.eclipse.titan.log.viewer.preferences.PreferencesHolder;
import org.eclipse.titan.log.viewer.utils.ResourcePropertyHandler;

public final class PreferencesHandler
implements IPropertyChangeListener {
    private static PreferencesHandler preferencesHandler;
    private IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
    private String valueContentType;
    private String sutName;
    private boolean verbosePrintout = this.stringToBoolean(this.preferenceStore.getString("org.eclipse.titan.log.viewer_verbose_printout_id"));
    private boolean replaceCompVisOrder;
    private boolean openPropAfterExtComp;
    private Map<String, Integer> filteredComponents;
    private Map<String, Integer> filteredSignals;
    private Map<String, Integer> filteredFunctions;
    private List<String> componentVisualOrder;
    private Map<String, Boolean> filteredSilentEvents;
    private int mscViewOpen;
    private int projectTabDefault;
    private int testcaseTabDefault;
    private int mscViewDefault;
    private boolean setverdictError;
    private boolean setverdictFail;
    private boolean setverdictInconc;
    private boolean setverdictPass;
    private boolean setverdictNone;
    private List<String> errorCausedBy;
    private List<String> failCausedBy;
    private Map<String, RGB> coloringKeywords;
    private boolean useColoringKeywords;
    private boolean filteredConnectingPorts;
    private boolean filteredMappingPorts;

    private PreferencesHandler() {
        this.valueContentType = this.getValueContentType(this.preferenceStore.getString("org.eclipse.titan.log.viewer_asn11_default"));
        this.filteredComponents = this.getFilters(this.preferenceStore.getString("org.eclipse.titan.log.viewer_filter_component_id"));
        this.filteredSignals = this.getFilters(this.preferenceStore.getString("org.eclipse.titan.log.viewer_filter_signals_id"));
        this.filteredFunctions = this.getFilters(this.preferenceStore.getString("org.eclipse.titan.log.viewer_filter_functions_id"));
        this.componentVisualOrder = this.stringListToArray(this.preferenceStore.getString("org.eclipse.titan.log.viewer_component_order_id"));
        this.filteredSilentEvents = this.silentEventsStringToArray(this.preferenceStore.getString("org.eclipse.titan.log.viewer_filter_silent_event_categories"));
        this.replaceCompVisOrder = this.replaceCompVisOrdWhenAdding(this.preferenceStore.getString("org.eclipse.titan.log.viewer_add_comp_to_vis_order_rep_app_id"));
        this.openPropAfterExtComp = this.stringToBoolean(this.preferenceStore.getString("org.eclipse.titan.log.viewer_add_comp_to_vis_order_open_prop_id"));
        this.mscViewOpen = this.getMSCViewOpenType(this.preferenceStore.getString("org.eclipse.titan.log.viewer_open_mscview_display"));
        this.projectTabDefault = this.getProjectTabDefault(this.preferenceStore.getString("org.eclipse.titan.log.viewer_projecttab_default"));
        this.testcaseTabDefault = this.getTestcaseTabDefault(this.preferenceStore.getString("org.eclipse.titan.log.viewer_projecttab_default"));
        this.mscViewDefault = this.getMSCViewDefault(this.preferenceStore.getString("org.eclipse.titan.log.viewer_projecttab_default"));
        this.setverdictError = this.stringToBoolean(this.preferenceStore.getString("org.eclipse.titan.log.setverdict_error_id"));
        this.setverdictFail = this.stringToBoolean(this.preferenceStore.getString("org.eclipse.titan.log.setverdict_fail_id"));
        this.setverdictInconc = this.stringToBoolean(this.preferenceStore.getString("org.eclipse.titan.log.setverdict_inconc_id"));
        this.setverdictNone = this.stringToBoolean(this.preferenceStore.getString("org.eclipse.titan.log.setverdict_none_id"));
        this.setverdictPass = this.stringToBoolean(this.preferenceStore.getString("org.eclipse.titan.log.setverdict_pass_id"));
        this.componentVisualOrder = this.stringListToArray(this.preferenceStore.getString("org.eclipse.titan.log.viewer_component_order_id"));
        this.componentVisualOrder = this.stringListToArray(this.preferenceStore.getString("org.eclipse.titan.log.viewer_component_order_id"));
        this.coloringKeywords = this.getColors(this.preferenceStore.getString("org.eclipse.titan.log.viewer_highlight_keyword_id"));
        this.useColoringKeywords = this.stringToBoolean(this.preferenceStore.getString("org.eclipse.titan.log.viewer_use_highlight_id"));
        this.filteredConnectingPorts = this.stringToBoolean(this.preferenceStore.getString("org.eclipse.titan.log.connecting_ports_id"));
        this.filteredMappingPorts = this.stringToBoolean(this.preferenceStore.getString("org.eclipse.titan.log.mapping_ports_id"));
    }

    public static synchronized PreferencesHandler getInstance() {
        if (preferencesHandler == null) {
            preferencesHandler = new PreferencesHandler();
            Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)preferencesHandler);
        }
        return preferencesHandler;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (!property.startsWith("org.eclipse.titan.log.viewer")) {
            return;
        }
        if (property.equals("org.eclipse.titan.log.viewer_verbose_printout_id")) {
            this.verbosePrintout = this.stringToBoolean(this.preferenceStore.getString("org.eclipse.titan.log.viewer_verbose_printout_id"));
        } else if (property.equals("org.eclipse.titan.log.viewer_sut_id")) {
            this.sutName = this.preferenceStore.getString("org.eclipse.titan.log.viewer_sut_id");
        } else if (property.equals("org.eclipse.titan.log.viewer_filter_component_id")) {
            this.filteredComponents = this.getFilters(this.preferenceStore.getString("org.eclipse.titan.log.viewer_filter_component_id"));
        } else if (property.equals("org.eclipse.titan.log.viewer_filter_signals_id")) {
            this.filteredSignals = this.getFilters(this.preferenceStore.getString("org.eclipse.titan.log.viewer_filter_signals_id"));
        } else if (property.equals("org.eclipse.titan.log.viewer_filter_functions_id")) {
            this.filteredFunctions = this.getFilters(this.preferenceStore.getString("org.eclipse.titan.log.viewer_filter_functions_id"));
        } else if (property.equals("org.eclipse.titan.log.viewer_component_order_id")) {
            this.componentVisualOrder = this.stringListToArray(this.preferenceStore.getString("org.eclipse.titan.log.viewer_component_order_id"));
        } else if (property.equals("org.eclipse.titan.log.viewer_asn11_default")) {
            this.valueContentType = this.getValueContentType(this.preferenceStore.getString("org.eclipse.titan.log.viewer_asn11_default"));
        } else if (property.equals("org.eclipse.titan.log.viewer_filter_silent_event_categories")) {
            this.filteredSilentEvents = this.silentEventsStringToArray(this.preferenceStore.getDefaultString("org.eclipse.titan.log.viewer_filter_silent_event_categories"));
        } else if (property.equals("org.eclipse.titan.log.viewer_add_comp_to_vis_order_rep_app_id")) {
            this.replaceCompVisOrder = this.replaceCompVisOrdWhenAdding(this.preferenceStore.getString("org.eclipse.titan.log.viewer_add_comp_to_vis_order_rep_app_id"));
        } else if (property.equals("org.eclipse.titan.log.viewer_add_comp_to_vis_order_open_prop_id")) {
            this.openPropAfterExtComp = this.stringToBoolean(this.preferenceStore.getString("org.eclipse.titan.log.viewer_add_comp_to_vis_order_open_prop_id"));
        } else if (property.equals("org.eclipse.titan.log.viewer_open_mscview_display")) {
            this.mscViewOpen = this.getMSCViewOpenType(this.preferenceStore.getString("org.eclipse.titan.log.viewer_open_mscview_display"));
        } else if (property.equals("org.eclipse.titan.log.setverdict_error_id")) {
            this.setverdictError = this.stringToBoolean(this.preferenceStore.getString("org.eclipse.titan.log.setverdict_error_id"));
        } else if (property.equals("org.eclipse.titan.log.setverdict_fail_id")) {
            this.setverdictFail = this.stringToBoolean(this.preferenceStore.getString("org.eclipse.titan.log.setverdict_fail_id"));
        } else if (property.equals("org.eclipse.titan.log.setverdict_inconc_id")) {
            this.setverdictInconc = this.stringToBoolean(this.preferenceStore.getString("org.eclipse.titan.log.setverdict_inconc_id"));
        } else if (property.equals("org.eclipse.titan.log.setverdict_none_id")) {
            this.setverdictNone = this.stringToBoolean(this.preferenceStore.getString("org.eclipse.titan.log.setverdict_none_id"));
        } else if (property.equals("org.eclipse.titan.log.setverdict_pass_id")) {
            this.setverdictPass = this.stringToBoolean(this.preferenceStore.getString("org.eclipse.titan.log.setverdict_pass_id"));
        } else if (property.equals("org.eclipse.titan.log.viewer_use_highlight_id")) {
            this.useColoringKeywords = this.stringToBoolean(this.preferenceStore.getString("org.eclipse.titan.log.viewer_use_highlight_id"));
        } else if (property.equals("org.eclipse.titan.log.viewer_highlight_keyword_id")) {
            this.coloringKeywords = this.getColors(this.preferenceStore.getString("org.eclipse.titan.log.viewer_highlight_keyword_id"));
        } else if (property.equals("org.eclipse.titan.log.connecting_ports_id")) {
            this.filteredConnectingPorts = this.stringToBoolean(this.preferenceStore.getString("org.eclipse.titan.log.connecting_ports_id"));
        } else if (property.equals("org.eclipse.titan.log.mapping_ports_id")) {
            this.filteredMappingPorts = this.stringToBoolean(this.preferenceStore.getString("org.eclipse.titan.log.mapping_ports_id"));
        }
    }

    public void removeListener() {
        this.preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public PreferencesHolder getPreferences(String project) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        IProject iProject = workspaceRoot.getProject(project);
        if (iProject.exists()) {
            return this.getOverlayedPreferencesHolder((IResource)iProject);
        }
        return this.getPreferencesHolder();
    }

    public String getLogFileLastDir() {
        return this.preferenceStore.getString("org.eclipse.titan.log.viewer_log_file_last_dir_id");
    }

    public void setLogFileLastDir(String lastDir) {
        this.preferenceStore.setValue("org.eclipse.titan.log.viewer_log_file_last_dir_id", lastDir);
    }

    public String getLogFolderLastDir() {
        return this.preferenceStore.getString("org.eclipse.titan.log.viewer_log_folder_last_dir_id");
    }

    public void setLogFolderLastDir(String lastDir) {
        this.preferenceStore.setValue("org.eclipse.titan.log.viewer_log_folder_last_dir_id", lastDir);
    }

    public String getImportLastDir() {
        return this.preferenceStore.getString("org.eclipse.titan.log.viewer_log_import_last_dir_id");
    }

    public void setImportLastDir(String lastDir) {
        this.preferenceStore.setValue("org.eclipse.titan.log.viewer_log_import_last_dir_id", lastDir);
    }

    public String getExportLastDir() {
        return this.preferenceStore.getString("org.eclipse.titan.log.viewer_log_export_last_dir_id");
    }

    public void setExportLastDir(String lastDir) {
        this.preferenceStore.setValue("org.eclipse.titan.log.viewer_log_export_last_dir_id", lastDir);
    }

    private String getValueContentType(String valueContentType) {
        if (valueContentType.contentEquals("org.eclipse.titan.log.viewer_asn1_textview")) {
            return "text";
        }
        return "tree";
    }

    private int getMSCViewOpenType(String mscViewOpen) {
        if (mscViewOpen.contentEquals("org.eclipse.titan.log.viewer_mscview_first_setverdict")) {
            return 2;
        }
        if (mscViewOpen.contentEquals("org.eclipse.titan.log.viewer_mscview_bottom")) {
            return 1;
        }
        return 0;
    }

    private boolean replaceCompVisOrdWhenAdding(String choice) {
        return choice.contentEquals("org.eclipse.titan.log.viewer_add_to_comp_replace");
    }

    private boolean stringToBoolean(String booleanString) {
        return booleanString.contentEquals("true");
    }

    private List<String> stringListToArray(String stringList) {
        StringTokenizer st = new StringTokenizer(stringList, File.pathSeparator);
        ArrayList<String> array = new ArrayList<String>();
        while (st.hasMoreElements()) {
            array.add((String)st.nextElement());
        }
        return array;
    }

    private PreferencesHolder getPreferencesHolder() {
        return new PreferencesHolder(this.verbosePrintout, this.valueContentType, this.sutName, this.filteredComponents, this.filteredSignals, this.filteredFunctions, this.componentVisualOrder, this.filteredSilentEvents, this.replaceCompVisOrder, this.openPropAfterExtComp, this.mscViewOpen, this.projectTabDefault, this.testcaseTabDefault, this.mscViewDefault, this.setverdictError, this.setverdictFail, this.setverdictInconc, this.setverdictNone, this.setverdictPass, this.errorCausedBy, this.failCausedBy, this.useColoringKeywords, this.coloringKeywords, this.filteredConnectingPorts, this.filteredMappingPorts);
    }

    private PreferencesHolder getOverlayedPreferencesHolder(IResource resource) {
        return new PreferencesHolder(this.stringToBoolean(this.getOverlayedPreferenceValue(resource, "org.eclipse.titan.log.viewer.properties.GeneralPage", "org.eclipse.titan.log.viewer_verbose_printout_id")), this.getValueContentType(this.getOverlayedPreferenceValue(resource, "org.eclipse.titan.log.viewer.properties.GeneralPage", "org.eclipse.titan.log.viewer_asn11_default")), this.getOverlayedPreferenceValue(resource, "org.eclipse.titan.log.viewer.properties.GeneralPage", "org.eclipse.titan.log.viewer_sut_id"), this.getFilters(this.getOverlayedPreferenceValue(resource, "org.eclipse.titan.log.viewer.properties.FilteredCompPage", "org.eclipse.titan.log.viewer_filter_component_id")), this.getFilters(this.getOverlayedPreferenceValue(resource, "org.eclipse.titan.log.viewer.properties.FilteredSignalsPage", "org.eclipse.titan.log.viewer_filter_signals_id")), this.getFilters(this.getOverlayedPreferenceValue(resource, "org.eclipse.titan.log.viewer.properties.FilteredFunctionsPage", "org.eclipse.titan.log.viewer_filter_functions_id")), this.stringListToArray(this.getOverlayedPreferenceValue(resource, "org.eclipse.titan.log.viewer.properties.CompVisOrderPage", "org.eclipse.titan.log.viewer_component_order_id")), this.silentEventsStringToArray(this.getOverlayedPreferenceValue(resource, "org.eclipse.titan.log.viewer.properties.FilteredSilentEventsPage", "org.eclipse.titan.log.viewer_filter_silent_event_categories")), this.replaceCompVisOrdWhenAdding(this.getOverlayedPreferenceValue(resource, "org.eclipse.titan.log.viewer.properties.GeneralPage", "org.eclipse.titan.log.viewer_add_comp_to_vis_order_rep_app_id")), this.stringToBoolean(this.getOverlayedPreferenceValue(resource, "org.eclipse.titan.log.viewer.properties.GeneralPage", "org.eclipse.titan.log.viewer_add_comp_to_vis_order_open_prop_id")), this.getMSCViewOpenType(this.getOverlayedPreferenceValue(resource, "org.eclipse.titan.log.viewer.properties.GeneralPage", "org.eclipse.titan.log.viewer_open_mscview_display")), this.getProjectTabDefault(this.getOverlayedPreferenceValue(resource, "org.eclipse.titan.log.viewer.properties.GeneralPage", "org.eclipse.titan.log.viewer_projecttab_default")), this.getTestcaseTabDefault(this.getOverlayedPreferenceValue(resource, "org.eclipse.titan.log.viewer.properties.GeneralPage", "org.eclipse.titan.log.viewer_testcasetab_default")), this.getMSCViewDefault(this.getOverlayedPreferenceValue(resource, "org.eclipse.titan.log.viewer.properties.GeneralPage", "org.eclipse.titan.log.viewer_mscview_default")), this.stringToBoolean(this.getOverlayedPreferenceValue(resource, "org.eclipse.titan.log.viewer.properties.SetverdictPreferencePage", "org.eclipse.titan.log.setverdict_error_id")), this.stringToBoolean(this.getOverlayedPreferenceValue(resource, "org.eclipse.titan.log.viewer.properties.SetverdictPreferencePage", "org.eclipse.titan.log.setverdict_fail_id")), this.stringToBoolean(this.getOverlayedPreferenceValue(resource, "org.eclipse.titan.log.viewer.properties.SetverdictPreferencePage", "org.eclipse.titan.log.setverdict_inconc_id")), this.stringToBoolean(this.getOverlayedPreferenceValue(resource, "org.eclipse.titan.log.viewer.properties.SetverdictPreferencePage", "org.eclipse.titan.log.setverdict_none_id")), this.stringToBoolean(this.getOverlayedPreferenceValue(resource, "org.eclipse.titan.log.viewer.properties.SetverdictPreferencePage", "org.eclipse.titan.log.setverdict_pass_id")), this.stringListToArray(this.getOverlayedPreferenceValue(resource, "org.eclipse.titan.log.viewer.properties.SetverdictPreferencePage", "org.eclipse.titan.log.error_caused_by_id")), this.stringListToArray(this.getOverlayedPreferenceValue(resource, "org.eclipse.titan.log.viewer.properties.SetverdictPreferencePage", "org.eclipse.titan.log.fail_caused_by_id")), this.stringToBoolean(this.getOverlayedPreferenceValue(resource, "org.eclipse.titan.log.viewer.properties.GeneralPage", "org.eclipse.titan.log.viewer_use_highlight_id")), this.getColors(this.getOverlayedPreferenceValue(resource, "org.eclipse.titan.log.viewer.properties.GeneralPage", "org.eclipse.titan.log.viewer_highlight_keyword_id")), this.stringToBoolean(this.getOverlayedPreferenceValue(resource, "org.eclipse.titan.log.viewer.properties.FilteredPortsPreferencePage", "org.eclipse.titan.log.connecting_ports_id")), this.stringToBoolean(this.getOverlayedPreferenceValue(resource, "org.eclipse.titan.log.viewer.properties.FilteredPortsPreferencePage", "org.eclipse.titan.log.mapping_ports_id")));
    }

    private String getOverlayedPreferenceValue(IResource resource, String pageId, String keyName) {
        IProject project = resource.getProject();
        String value = null;
        if (this.useProjectSettings((IResource)project, pageId)) {
            value = ResourcePropertyHandler.getProperty(resource, pageId, keyName);
        }
        if (value != null) {
            return value;
        }
        return this.preferenceStore.getString(keyName);
    }

    private boolean useProjectSettings(IResource resource, String pageId) {
        String usingProjectSetting = ResourcePropertyHandler.getProperty(resource, pageId, "useProjectSettings");
        return usingProjectSetting != null && "true".equals(usingProjectSetting);
    }

    public synchronized void dispose() {
        try {
            preferencesHandler = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Map<String, Boolean> silentEventsStringToArray(String prefValues) {
        String[] categories = prefValues.split(";");
        HashMap<String, Boolean> silentEvents = new HashMap<String, Boolean>();
        for (String category : categories) {
            String[] currCategory = category.split("=");
            if (currCategory.length <= 1) continue;
            silentEvents.put(currCategory[0], Boolean.valueOf(currCategory[1]));
        }
        return silentEvents;
    }

    private int getProjectTabDefault(String projectTabDefault) {
        if (projectTabDefault.contentEquals("org.eclipse.titan.log.viewer_projecttab_default_extract_testcases")) {
            return 3;
        }
        if (projectTabDefault.contentEquals("org.eclipse.titan.log.viewer_projecttab_default_text")) {
            return 0;
        }
        return 3;
    }

    private int getTestcaseTabDefault(String testcaseTabDefault) {
        if (testcaseTabDefault.contentEquals("org.eclipse.titan.log.viewer_testcasetab_default_open_mscview")) {
            return 2;
        }
        if (testcaseTabDefault.contentEquals("org.eclipse.titan.log.viewer_testcasetab_default_text")) {
            return 0;
        }
        return 2;
    }

    private int getMSCViewDefault(String mscViewDefault) {
        if (mscViewDefault.contentEquals("org.eclipse.titan.log.viewer_mscview_default_valueview")) {
            return 1;
        }
        if (mscViewDefault.contentEquals("org.eclipse.titan.log.viewer_mscview_default_text")) {
            return 0;
        }
        return 1;
    }

    private Map<String, Integer> getFilters(String stringList) {
        StringTokenizer st = new StringTokenizer(stringList, File.pathSeparator);
        HashMap<String, Integer> filters = new HashMap<String, Integer>();
        while (st.hasMoreElements()) {
            String filter = (String)st.nextElement();
            if (filter.length() >= 3 && filter.startsWith("*") && filter.endsWith("*")) {
                filters.put(filter.substring(1, filter.length() - 1), 3);
                continue;
            }
            if (filter.length() >= 2 && filter.startsWith("*")) {
                filters.put(filter.substring(1, filter.length()), 2);
                continue;
            }
            if (filter.length() >= 2 && filter.endsWith("*")) {
                filters.put(filter.substring(0, filter.length() - 1), 1);
                continue;
            }
            filters.put(filter, 0);
        }
        return filters;
    }

    private Map<String, RGB> getColors(String stringList) {
        StringTokenizer stringColors = new StringTokenizer(stringList, File.pathSeparator);
        HashMap<String, RGB> keyWordColors = new HashMap<String, RGB>();
        String item = null;
        String color = null;
        RGB rgb = null;
        while (stringColors.hasMoreElements()) {
            String stringColor = (String)stringColors.nextElement();
            String[] sc = stringColor.split("#");
            if (sc.length > 1) {
                item = sc[0];
                color = sc[1];
            }
            if (color != null && color.trim().length() > 0) {
                String[] splitColor = color.split(",");
                int red = Integer.parseInt(splitColor[0]);
                int green = Integer.parseInt(splitColor[1]);
                int blue = Integer.parseInt(splitColor[2]);
                rgb = new RGB(red, green, blue);
            }
            if (item == null || rgb == null) continue;
            keyWordColors.put(item, rgb);
        }
        return keyWordColors;
    }
}

