/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Task;
import org.eclipse.ant.core.AntSecurityException;
import org.eclipse.ant.internal.ui.model.AntModelMessages;
import org.eclipse.ant.internal.ui.model.AntTaskNode;

public class AntAugmentTaskNode
extends AntTaskNode {
    String attrId = null;

    public AntAugmentTaskNode(Task task, String label) {
        super(task, label);
        RuntimeConfigurable wrapper = task.getRuntimeConfigurableWrapper();
        this.attrId = (String)wrapper.getAttributeMap().get("id");
    }

    @Override
    public boolean configure(boolean validateFully) {
        if (this.fConfigured) {
            return false;
        }
        try {
            this.getTask().maybeConfigure();
            this.fConfigured = true;
            return true;
        }
        catch (BuildException be) {
            this.handleBuildException(be, "problem_tasks");
        }
        catch (AntSecurityException antSecurityException) {
            this.handleBuildException(new BuildException(AntModelMessages.AntTaskNode_0), "problem_security");
        }
        catch (IllegalStateException ise) {
            this.handleBuildException(new BuildException((Throwable)ise), "problem_tasks");
        }
        return false;
    }

    @Override
    public boolean containsOccurrence(String identifier) {
        if (identifier != null) {
            boolean prop;
            boolean bl = prop = identifier.startsWith("${") && identifier.endsWith("}");
            if (!prop) {
                return identifier.equals(this.attrId);
            }
            return this.attrId != null && identifier.indexOf(this.attrId) > -1;
        }
        return false;
    }

    @Override
    public List<Integer> computeIdentifierOffsets(String identifier) {
        if (this.attrId != null && identifier != null && identifier.length() > 0) {
            String text = this.getAntModel().getText(this.getOffset(), this.getLength());
            if (text == null || text.length() == 0) {
                return null;
            }
            ArrayList<Integer> list = new ArrayList<Integer>();
            int idx = text.indexOf(this.attrId);
            if (idx > -1) {
                list.add(new Integer(this.getOffset() + idx));
            }
            return list;
        }
        return null;
    }
}

