/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.engine.portals;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.View;
import fr.inria.zvtm.engine.portals.CameraPortal;
import fr.inria.zvtm.event.ObservedRegionListener;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.Translucent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class OverviewPortal
extends CameraPortal {
    Camera observedRegionCamera;
    View observedRegionView;
    double[] observedRegion;
    double orcoef;
    Color observedRegionColor = Color.GREEN;
    AlphaComposite acST;
    float alpha = 0.5f;
    Timer borderTimer;
    boolean drawObservedRegionLocator = false;
    ObservedRegionListener observedRegionListener;

    public OverviewPortal(int x, int y, int w, int h, Camera pc, Camera orc) {
        super(x, y, w, h, pc);
        this.observedRegionCamera = orc;
        this.observedRegionView = orc.getOwningView();
        this.observedRegion = new double[4];
        this.borderTimer = new Timer();
        this.borderTimer.scheduleAtFixedRate((TimerTask)new BorderTimer(this), 40L, 40L);
    }

    public void drawObservedRegionLocator(boolean b) {
        this.drawObservedRegionLocator = b;
    }

    public boolean isDrawObservedRegionLocator() {
        return this.drawObservedRegionLocator;
    }

    public boolean coordInsideObservedRegion(int cx, int cy) {
        return (long)cx >= (long)(this.x + this.w / 2) + Math.round((this.observedRegion[0] - this.camera.vx) * this.orcoef) && (long)cy >= (long)(this.y + this.h / 2) + Math.round((this.camera.vy - this.observedRegion[1]) * this.orcoef) && (long)cx <= (long)(this.x + this.w / 2) + Math.round((this.observedRegion[2] - this.camera.vx) * this.orcoef) && (long)cy <= (long)(this.y + this.h / 2) + Math.round((this.camera.vy - this.observedRegion[3]) * this.orcoef);
    }

    public void setObservedRegionColor(Color c) {
        this.observedRegionColor = c;
    }

    public Color getObservedRegionColor() {
        return this.observedRegionColor;
    }

    public void setObservedRegionTranslucency(float a) {
        this.acST = a == 1.0f ? null : AlphaComposite.getInstance(3, a);
    }

    public double getObservedRegionX() {
        this.orcoef = this.camera.focal / (this.camera.focal + this.camera.altitude);
        return (double)this.x + (double)this.w / 2.0 + (this.observedRegion[0] - this.camera.vx) * this.orcoef;
    }

    public double getObservedRegionY() {
        this.orcoef = this.camera.focal / (this.camera.focal + this.camera.altitude);
        return (double)this.y + (double)this.h / 2.0 - (this.observedRegion[1] - this.camera.vy) * this.orcoef;
    }

    public double getObservedRegionW() {
        this.orcoef = this.camera.focal / (this.camera.focal + this.camera.altitude);
        return (this.observedRegion[2] - this.observedRegion[0]) * this.orcoef;
    }

    public double getObservedRegionH() {
        this.orcoef = this.camera.focal / (this.camera.focal + this.camera.altitude);
        return (this.observedRegion[1] - this.observedRegion[3]) * this.orcoef;
    }

    public double getObservedRegionCX() {
        return this.getObservedRegionX() + this.getObservedRegionW() / 2.0;
    }

    public double getObservedRegionCY() {
        return this.getObservedRegionY() + this.getObservedRegionH() / 2.0;
    }

    public AlphaComposite getObservedRegionTranslucency() {
        return this.acST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D g2d, int viewWidth, int viewHeight) {
        if (!this.visible) {
            return;
        }
        g2d.setClip(this.x, this.y, this.w, this.h);
        if (this.bkgColor != null) {
            g2d.setColor(this.bkgColor);
            g2d.fillRect(this.x, this.y, this.w, this.h);
        }
        this.standardStroke = g2d.getStroke();
        this.standardTransform = g2d.getTransform();
        this.drawnGlyphs = this.cameraSpace.getDrawnGlyphs(this.camIndex);
        Vector vector = this.drawnGlyphs;
        synchronized (vector) {
            this.drawnGlyphs.removeAllElements();
            this.duncoef = (this.camera.focal + this.camera.altitude) / this.camera.focal;
            this.viewWC = this.camera.vx - (double)(this.w / 2) * this.duncoef;
            this.viewNC = this.camera.vy + (double)(this.h / 2) * this.duncoef;
            this.viewEC = this.camera.vx + (double)(this.w / 2) * this.duncoef;
            this.viewSC = this.camera.vy - (double)(this.h / 2) * this.duncoef;
            this.gll = this.cameraSpace.getDrawingList();
            for (int i = 0; i < this.gll.length; ++i) {
                if (this.gll[i] == null) continue;
                Glyph glyph = this.gll[i];
                synchronized (glyph) {
                    if (this.gll[i].visibleInViewport(this.viewWC, this.viewNC, this.viewEC, this.viewSC, this.camera)) {
                        this.gll[i].project(this.camera, this.size);
                        if (this.gll[i].isVisible()) {
                            this.gll[i].draw(g2d, this.w, this.h, this.camIndex, this.standardStroke, this.standardTransform, this.x, this.y);
                        }
                        this.cameraSpace.drewGlyph(this.gll[i], this.camIndex);
                    }
                    continue;
                }
            }
        }
        this.observedRegion = this.observedRegionView.getVisibleRegion(this.observedRegionCamera, this.observedRegion);
        g2d.setColor(this.observedRegionColor);
        this.orcoef = (float)(this.camera.focal / (this.camera.focal + this.camera.altitude));
        int nwx = (int)((long)(this.x + this.w / 2) + Math.round((this.observedRegion[0] - this.camera.vx) * this.orcoef));
        int nwy = (int)((long)(this.y + this.h / 2) - Math.round((this.observedRegion[1] - this.camera.vy) * this.orcoef));
        int orw = (int)Math.round((this.observedRegion[2] - this.observedRegion[0]) * this.orcoef);
        int orh = (int)Math.round((this.observedRegion[1] - this.observedRegion[3]) * this.orcoef);
        if (this.acST != null) {
            g2d.setComposite(this.acST);
            g2d.fillRect(nwx, nwy, orw, orh);
            g2d.setComposite(Translucent.acO);
        }
        g2d.setStroke(this.standardStroke);
        g2d.drawRect(nwx, nwy, orw, orh);
        if (this.drawObservedRegionLocator) {
            g2d.drawRect(this.x, nwy + orh / 2, nwx - this.x, 1);
            g2d.drawRect(nwx + orw / 2, this.y, 1, nwy - this.y);
            g2d.drawRect(nwx + orw, nwy + orh / 2, this.x + this.w - (nwx + orw), 1);
            g2d.drawRect(nwx + orw / 2, nwy + orh, 1, this.y + this.h - (nwy + orh));
        }
        g2d.setClip(0, 0, viewWidth, viewHeight);
        if (this.borderColor != null) {
            g2d.setColor(this.borderColor);
            g2d.drawRect(this.x, this.y, this.w, this.h);
        }
    }

    public void dispose() {
        this.borderTimer.cancel();
    }

    public void setObservedRegionListener(ObservedRegionListener orl) {
        this.observedRegionListener = orl;
    }

    void observedRegionIntersects(double[] wnes) {
        if (this.observedRegionListener != null) {
            this.observedRegionListener.intersectsParentRegion(wnes);
        }
    }

    private class BorderTimer
    extends TimerTask {
        OverviewPortal portal;
        double[] portalRegion = new double[4];
        double[] intersection = new double[4];

        BorderTimer(OverviewPortal p) {
            this.portal = p;
        }

        public void run() {
            this.portal.getVisibleRegion(this.portalRegion);
            this.intersection[0] = this.portal.observedRegion[0] - this.portalRegion[0];
            this.intersection[1] = this.portal.observedRegion[1] - this.portalRegion[1];
            this.intersection[2] = this.portal.observedRegion[2] - this.portalRegion[2];
            this.intersection[3] = this.portal.observedRegion[3] - this.portalRegion[3];
            this.portal.observedRegionIntersects(this.intersection);
        }
    }
}

