/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.css.swt.dom.scrollbar;

import org.eclipse.swt.graphics.Rectangle;

public abstract class ScrollBarPositions {
    protected int fMinimum;
    protected int fMaximum;
    protected int fPixel;
    protected int fSize;
    protected int fLargeness;
    protected int fScrollBarPos;
    protected int fScrollBarSize;
    protected double fPercentageOfClientAreaFromTotalArea;
    private int fMinimumScrollBarSize = 30;
    private int fScrollBarDiff;

    public ScrollBarPositions(int minimum, int maximum, int pixel, int size, int largeness) {
        int scrollBarPos;
        this.fMinimum = minimum;
        this.fMaximum = maximum;
        this.fPixel = pixel;
        this.fSize = size;
        this.fLargeness = largeness;
        double total = maximum - minimum;
        double percentageOfClientAreaFromTotalArea = (double)size / total;
        int scrollBarSize = (int)Math.round((double)size * percentageOfClientAreaFromTotalArea);
        if (scrollBarSize < this.fMinimumScrollBarSize) {
            int diff = this.fMinimumScrollBarSize - scrollBarSize;
            percentageOfClientAreaFromTotalArea = (double)(this.fSize - diff) / total;
            scrollBarPos = (int)((double)this.fPixel * percentageOfClientAreaFromTotalArea);
            scrollBarSize = this.fMinimumScrollBarSize;
            this.fScrollBarDiff = diff;
        } else {
            percentageOfClientAreaFromTotalArea = (double)this.fSize / total;
            this.fScrollBarDiff = 0;
            scrollBarPos = (int)Math.round((double)this.fPixel * percentageOfClientAreaFromTotalArea);
        }
        this.fPercentageOfClientAreaFromTotalArea = percentageOfClientAreaFromTotalArea;
        this.fScrollBarPos = scrollBarPos;
        this.fScrollBarSize = scrollBarSize;
    }

    public double convertFromScrollBarPosToControlPixel(int pos) {
        return (double)pos * (double)this.fMaximum / (double)(this.fSize - this.fScrollBarDiff);
    }

    public abstract Rectangle getHandleDrawRect(int var1);

    public static class ScrollBarPositionsHorizontal
    extends ScrollBarPositions {
        public ScrollBarPositionsHorizontal(int minimum, int maximum, int horizontalPixel, int clientAreaHeight, int clientAreaWidth) {
            super(minimum, maximum, horizontalPixel, clientAreaWidth, clientAreaHeight);
        }

        @Override
        public Rectangle getHandleDrawRect(int lineWidth) {
            return new Rectangle(this.fScrollBarPos, this.fLargeness - lineWidth, this.fScrollBarSize, lineWidth);
        }
    }

    public static class ScrollBarPositionsVertical
    extends ScrollBarPositions {
        public ScrollBarPositionsVertical(int minimum, int maximum, int topPixel, int clientAreaHeight, int clientAreaWidth) {
            super(minimum, maximum, topPixel, clientAreaHeight, clientAreaWidth);
        }

        @Override
        public Rectangle getHandleDrawRect(int lineWidth) {
            return new Rectangle(this.fLargeness - lineWidth, this.fScrollBarPos, lineWidth, this.fScrollBarSize);
        }
    }
}

