/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.perspectiveswitcher;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.e4.compatibility.E4Util;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.service.event.Event;

public class PerspectiveSwitcher {
    public static final String PERSPECTIVE_SWITCHER_ID = "org.eclipse.e4.ui.PerspectiveSwitcher";
    @Inject
    protected IEventBroker eventBroker;
    @Inject
    EModelService modelService;
    @Inject
    private EHandlerService handlerService;
    @Inject
    private ECommandService commandService;
    @Inject
    private MWindow window;
    @Inject
    private Logger logger;
    private MToolControl perspSwitcherToolControl;
    private ToolBar perspSwitcherToolbar;
    private Composite comp;
    private Image perspectiveImage;
    Control toolParent;
    IPropertyChangeListener propertyChangeListener;
    protected Point downPos = null;
    protected ToolItem dragItem = null;
    protected boolean dragging = false;
    protected Shell dragShell = null;

    @Inject
    @Optional
    void handleChildrenEvent(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/ElementContainer/children/*") Event event) {
        block4: {
            block3: {
                Object changedObj = event.getProperty("ChangedElement");
                if (!(changedObj instanceof MPerspectiveStack) || this.ignoreEvent(changedObj)) {
                    return;
                }
                if (!UIEvents.isADD((Event)event)) break block3;
                for (Object o : UIEvents.asIterable((Event)event, (String)"NewValue")) {
                    MPerspective added = (MPerspective)o;
                    if (!added.isToBeRendered()) continue;
                    this.addPerspectiveItem(added);
                }
                break block4;
            }
            if (!UIEvents.isREMOVE((Event)event)) break block4;
            for (Object o : UIEvents.asIterable((Event)event, (String)"OldValue")) {
                MPerspective removed = (MPerspective)o;
                if (!removed.isToBeRendered()) continue;
                this.removePerspectiveItem(removed);
            }
        }
    }

    @Inject
    @Optional
    void handleToBeRenderedEvent(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/UIElement/toBeRendered/*") Event event) {
        Object changedObj = event.getProperty("ChangedElement");
        if (!(changedObj instanceof MPerspective) || this.ignoreEvent(changedObj)) {
            return;
        }
        MPerspective persp = (MPerspective)event.getProperty("ChangedElement");
        if (!persp.getParent().isToBeRendered()) {
            return;
        }
        if (persp.isToBeRendered()) {
            this.addPerspectiveItem(persp);
        } else {
            this.removePerspectiveItem(persp);
        }
    }

    @Inject
    @Optional
    void handleLabelEvent(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/UILabel/*") Event event) {
        Object changedObj = event.getProperty("ChangedElement");
        if (!(changedObj instanceof MPerspective) || this.ignoreEvent(changedObj)) {
            return;
        }
        MPerspective perspective = (MPerspective)changedObj;
        if (!perspective.isToBeRendered()) {
            return;
        }
        ToolItem[] toolItemArray = this.perspSwitcherToolbar.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem ti = toolItemArray[n2];
            if (ti.getData() == perspective) {
                String attName = (String)event.getProperty("AttName");
                Object newValue = event.getProperty("NewValue");
                this.updateToolItem(ti, attName, newValue);
            }
            ++n2;
        }
        this.fixSize();
    }

    @Inject
    @Optional
    void handleSelectionEvent(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*") Event event) {
        Object changedObj = event.getProperty("ChangedElement");
        if (!(changedObj instanceof MPerspectiveStack) || this.ignoreEvent(changedObj)) {
            return;
        }
        MPerspectiveStack perspStack = (MPerspectiveStack)changedObj;
        if (!perspStack.isToBeRendered()) {
            return;
        }
        MPerspective selElement = (MPerspective)perspStack.getSelectedElement();
        ToolItem[] toolItemArray = this.perspSwitcherToolbar.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem ti;
            ti.setSelection((ti = toolItemArray[n2]).getData() == selElement);
            ++n2;
        }
    }

    @PostConstruct
    void init() {
        this.setPropertyChangeListener();
    }

    @PreDestroy
    void cleanUp() {
        if (this.perspectiveImage != null) {
            this.perspectiveImage.dispose();
            this.perspectiveImage = null;
        }
        PrefUtil.getAPIPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
    }

    @PostConstruct
    void createWidget(Composite parent, MToolControl toolControl) {
        MPerspectiveStack stack;
        MTrimBar bar;
        this.perspSwitcherToolControl = toolControl;
        MElementContainer meParent = this.perspSwitcherToolControl.getParent();
        int orientation = 256;
        if (meParent instanceof MTrimBar && ((bar = (MTrimBar)meParent).getSide() == SideValue.RIGHT || bar.getSide() == SideValue.LEFT)) {
            orientation = 512;
        }
        this.comp = new Composite(parent, 0);
        RowLayout layout = new RowLayout(256);
        layout.marginLeft = 0;
        layout.marginRight = 4;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        this.comp.setLayout((Layout)layout);
        this.perspSwitcherToolbar = new ToolBar(this.comp, 0x800040 | 131072 + orientation);
        this.toolParent = (Control)toolControl.getParent().getWidget();
        this.comp.addDisposeListener(e -> this.dispose());
        this.perspSwitcherToolbar.addMenuDetectListener(e -> {
            ToolBar tb = (ToolBar)e.widget;
            Point p = new Point(e.x, e.y);
            p = this.perspSwitcherToolbar.getDisplay().map(null, (Control)this.perspSwitcherToolbar, p);
            ToolItem item = tb.getItem(p);
            if (item == null) {
                E4Util.message("  ToolBar menu");
            } else {
                MPerspective persp = (MPerspective)item.getData();
                if (persp == null) {
                    E4Util.message("  Add button Menu");
                } else {
                    this.openMenuFor(item, persp);
                }
            }
        });
        this.perspSwitcherToolbar.addDisposeListener(e -> this.disposeTBImages());
        this.perspSwitcherToolbar.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                ToolItem item;
                if (e.childID >= 0 && e.childID < PerspectiveSwitcher.this.perspSwitcherToolbar.getItemCount() && (item = PerspectiveSwitcher.this.perspSwitcherToolbar.getItem(e.childID)) != null) {
                    e.result = item.getToolTipText();
                }
            }
        });
        this.hookupDnD(this.perspSwitcherToolbar);
        boolean showOpenOnPerspectiveBar = PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_OPEN_ON_PERSPECTIVE_BAR");
        if (showOpenOnPerspectiveBar) {
            ToolItem openPerspectiveItem = new ToolItem(this.perspSwitcherToolbar, 8);
            openPerspectiveItem.setImage(this.getOpenPerspectiveImage());
            openPerspectiveItem.setToolTipText(WorkbenchMessages.OpenPerspectiveDialogAction_tooltip);
            openPerspectiveItem.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.selectPerspective()));
            new ToolItem(this.perspSwitcherToolbar, 2);
        }
        if ((stack = this.getPerspectiveStack()) != null) {
            for (MPerspective persp : stack.getChildren()) {
                if (!persp.isToBeRendered()) continue;
                this.addPerspectiveItem(persp);
            }
        }
    }

    private boolean ignoreEvent(Object changedObj) {
        MWindow switcherWin;
        if (this.perspSwitcherToolControl == null || this.perspSwitcherToolbar.isDisposed()) {
            return true;
        }
        MWindow perspWin = this.modelService.getTopLevelWindowFor((MUIElement)changedObj);
        return perspWin != (switcherWin = this.modelService.getTopLevelWindowFor((MUIElement)this.perspSwitcherToolControl));
    }

    private void track(MouseEvent e) {
        if (this.dragShell == null) {
            this.createFeedback();
        }
        Rectangle b = this.dragItem.getBounds();
        Point p = new Point(e.x, e.y);
        p = this.dragShell.getDisplay().map((Control)this.dragItem.getParent(), null, p);
        this.dragShell.setLocation(p.x - b.width / 2, p.y - b.height / 2);
        ToolBar bar = (ToolBar)e.widget;
        ToolItem curItem = bar.getItem(new Point(e.x, e.y));
        if (curItem != null && curItem.getData() instanceof MPerspective) {
            this.perspSwitcherToolbar.setCursor(this.perspSwitcherToolbar.getDisplay().getSystemCursor(21));
        } else {
            this.perspSwitcherToolbar.setCursor(this.perspSwitcherToolbar.getDisplay().getSystemCursor(20));
        }
    }

    private void createFeedback() {
        this.dragShell = new Shell(262152);
        this.dragShell.setAlpha(175);
        ToolBar dragTB = new ToolBar((Composite)this.dragShell, 131072);
        ToolItem newTI = new ToolItem(dragTB, 16);
        newTI.setText(this.dragItem.getText());
        newTI.setImage(this.dragItem.getImage());
        dragTB.pack();
        this.dragShell.pack();
        this.dragShell.setVisible(true);
    }

    private void hookupDnD(ToolBar bar) {
        bar.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                if (PerspectiveSwitcher.this.dragItem == null) {
                    return;
                }
                ToolBar bar = (ToolBar)e.widget;
                ToolItem curItem = bar.getItem(new Point(e.x, e.y));
                if (curItem != null && curItem.getData() instanceof MPerspective) {
                    Rectangle bounds = curItem.getBounds();
                    Point center = new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
                    boolean atStart = (PerspectiveSwitcher.this.perspSwitcherToolbar.getStyle() & 0x100) != 0 ? e.x < center.x : e.y < center.y;
                    MPerspective dragPersp = (MPerspective)PerspectiveSwitcher.this.dragItem.getData();
                    int dragPerspIndex = dragPersp.getParent().getChildren().indexOf(dragPersp);
                    MPerspective dropPersp = (MPerspective)curItem.getData();
                    int dropPerspIndex = dropPersp.getParent().getChildren().indexOf(dropPersp);
                    if (!atStart) {
                        ++dropPerspIndex;
                    }
                    if (dropPerspIndex > dragPerspIndex) {
                        --dropPerspIndex;
                    }
                    if (dropPerspIndex != dragPerspIndex) {
                        MElementContainer parent = dragPersp.getParent();
                        boolean selected = dragPersp == parent.getSelectedElement();
                        parent.getChildren().remove(dragPersp);
                        parent.getChildren().add(dropPerspIndex, dragPersp);
                        if (selected) {
                            parent.setSelectedElement((MUIElement)dragPersp);
                        }
                    }
                }
                PerspectiveSwitcher.this.dragItem = null;
                PerspectiveSwitcher.this.downPos = null;
                PerspectiveSwitcher.this.dragging = false;
                PerspectiveSwitcher.this.perspSwitcherToolbar.setCursor(null);
                if (PerspectiveSwitcher.this.dragShell != null && !PerspectiveSwitcher.this.dragShell.isDisposed()) {
                    PerspectiveSwitcher.this.dragShell.dispose();
                }
                PerspectiveSwitcher.this.dragShell = null;
            }

            public void mouseDown(MouseEvent e) {
                ToolBar bar = (ToolBar)e.widget;
                PerspectiveSwitcher.this.downPos = new Point(e.x, e.y);
                ToolItem downItem = bar.getItem(PerspectiveSwitcher.this.downPos);
                if (downItem != null && downItem.getData() instanceof MPerspective) {
                    PerspectiveSwitcher.this.dragItem = downItem;
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        bar.addDragDetectListener(e -> {
            if (this.dragItem != null) {
                this.dragging = true;
                this.track((MouseEvent)e);
            }
        });
        bar.addMouseMoveListener(e -> {
            if (this.dragging) {
                this.track(e);
            }
        });
    }

    private Image getOpenPerspectiveImage() {
        if (this.perspectiveImage == null || this.perspectiveImage.isDisposed()) {
            ImageDescriptor desc = WorkbenchImages.getImageDescriptor("IMG_ETOOL_NEW_PAGE");
            this.perspectiveImage = desc.createImage();
        }
        return this.perspectiveImage;
    }

    MPerspectiveStack getPerspectiveStack() {
        List psList = this.modelService.findElements((MUIElement)this.window, null, MPerspectiveStack.class);
        if (psList.size() > 0) {
            return (MPerspectiveStack)psList.get(0);
        }
        return null;
    }

    private ToolItem addPerspectiveItem(MPerspective persp) {
        Image image;
        ImageDescriptor desc;
        int perspIndex = persp.getParent().getChildren().indexOf(persp);
        int index = perspIndex + 2;
        ToolItem psItem = index < this.perspSwitcherToolbar.getItemCount() ? new ToolItem(this.perspSwitcherToolbar, 16, index) : new ToolItem(this.perspSwitcherToolbar, 16);
        psItem.setData((Object)persp);
        IPerspectiveDescriptor descriptor = this.getDescriptorFor(persp.getElementId());
        boolean foundImage = false;
        if (descriptor != null && (desc = descriptor.getImageDescriptor()) != null && (image = desc.createImage(false)) != null) {
            psItem.setImage(image);
            psItem.addListener(12, event -> {
                Image currentImage = psItem.getImage();
                if (currentImage != null) {
                    currentImage.dispose();
                }
            });
            foundImage = true;
            psItem.setToolTipText(persp.getLocalizedLabel());
        }
        if (!foundImage || PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_TEXT_ON_PERSPECTIVE_BAR")) {
            psItem.setText(persp.getLocalizedLabel());
            psItem.setToolTipText(persp.getLocalizedTooltip());
        }
        psItem.setSelection(persp == persp.getParent().getSelectedElement());
        psItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BusyIndicator.showWhile(null, () -> {
                    MPerspective persp = (MPerspective)selectionEvent.widget.getData();
                    persp.getParent().setSelectedElement((MUIElement)persp);
                });
            }
        });
        psItem.addListener(35, event -> {
            MPerspective persp1 = (MPerspective)event.widget.getData();
            this.openMenuFor(psItem, persp1);
        });
        this.fixSize();
        return psItem;
    }

    private IPerspectiveDescriptor getDescriptorFor(String id) {
        IPerspectiveRegistry perspectiveRegistry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        if (perspectiveRegistry instanceof PerspectiveRegistry) {
            return ((PerspectiveRegistry)perspectiveRegistry).findPerspectiveWithId(id, false);
        }
        return perspectiveRegistry.findPerspectiveWithId(id);
    }

    private void selectPerspective() {
        ParameterizedCommand command = this.commandService.createCommand("org.eclipse.ui.perspectives.showPerspective", Collections.EMPTY_MAP);
        this.handlerService.executeHandler(command);
    }

    private void openMenuFor(ToolItem item, MPerspective persp) {
        Menu menu = new Menu((Control)this.perspSwitcherToolbar);
        menu.setData((Object)persp);
        if (persp.getParent().getSelectedElement() == persp) {
            this.addCustomizeItem(menu);
            this.addSaveAsItem(menu);
            this.addResetItem(menu);
        }
        if (persp.isVisible()) {
            this.addCloseItem(menu);
        }
        new MenuItem(menu, 2);
        this.addShowTextItem(menu);
        Rectangle bounds = item.getBounds();
        Point point = this.perspSwitcherToolbar.toDisplay(bounds.x, bounds.y + bounds.height);
        menu.setLocation(point.x, point.y);
        menu.setVisible(true);
        menu.addMenuListener(MenuListener.menuHiddenAdapter(e -> this.perspSwitcherToolbar.getDisplay().asyncExec(() -> ((Menu)menu).dispose())));
    }

    private void addCloseItem(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 0);
        menuItem.setText(WorkbenchMessages.WorkbenchWindow_close);
        menuItem.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            MPerspective persp = (MPerspective)menu.getData();
            if (persp != null) {
                this.closePerspective(persp);
            }
        }));
    }

    private void closePerspective(MPerspective persp) {
        WorkbenchPage page = (WorkbenchPage)this.window.getContext().get(IWorkbenchPage.class);
        String perspectiveId = persp.getElementId();
        IPerspectiveDescriptor desc = this.getDescriptorFor(perspectiveId);
        page.closePerspective(desc, perspectiveId, true, true);
    }

    private void addSaveAsItem(Menu menu) {
        MenuItem saveAsMenuItem = new MenuItem(menu, 8);
        saveAsMenuItem.setText(WorkbenchMessages.PerspectiveBar_saveAs);
        IWorkbenchWindow workbenchWindow = (IWorkbenchWindow)this.window.getContext().get(IWorkbenchWindow.class);
        workbenchWindow.getWorkbench().getHelpSystem().setHelp(saveAsMenuItem, "org.eclipse.ui.save_perspective_action_context");
        saveAsMenuItem.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            if (this.perspSwitcherToolbar.isDisposed()) {
                return;
            }
            IHandlerService handlerService = (IHandlerService)workbenchWindow.getService(IHandlerService.class);
            IStatus status = Status.OK_STATUS;
            try {
                handlerService.executeCommand("org.eclipse.ui.window.savePerspective", null);
            }
            catch (ExecutionException | NotEnabledException | NotDefinedException e) {
                status = new Status(4, "org.eclipse.ui", e.getMessage(), e);
            }
            catch (NotHandledException notHandledException) {}
            if (!status.isOK()) {
                StatusManager.getManager().handle(status, 3);
            }
        }));
    }

    private void addResetItem(Menu menu) {
        MenuItem resetMenuItem = new MenuItem(menu, 8);
        resetMenuItem.setText(WorkbenchMessages.PerspectiveBar_reset);
        IWorkbenchWindow workbenchWindow = (IWorkbenchWindow)this.window.getContext().get(IWorkbenchWindow.class);
        workbenchWindow.getWorkbench().getHelpSystem().setHelp(resetMenuItem, "org.eclipse.ui.reset_perspective_action_context");
        resetMenuItem.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            if (this.perspSwitcherToolbar.isDisposed()) {
                return;
            }
            IHandlerService handlerService = (IHandlerService)workbenchWindow.getService(IHandlerService.class);
            IStatus status = Status.OK_STATUS;
            try {
                handlerService.executeCommand("org.eclipse.ui.window.resetPerspective", null);
            }
            catch (ExecutionException | NotEnabledException | NotDefinedException e) {
                status = new Status(4, "org.eclipse.ui", e.getMessage(), e);
            }
            catch (NotHandledException notHandledException) {}
            if (!status.isOK()) {
                StatusManager.getManager().handle(status, 3);
            }
        }));
    }

    private void addCustomizeItem(Menu menu) {
        MenuItem customizeMenuItem = new MenuItem(menu, 8);
        customizeMenuItem.setText(WorkbenchMessages.PerspectiveBar_customize);
        IWorkbenchWindow workbenchWindow = (IWorkbenchWindow)this.window.getContext().get(IWorkbenchWindow.class);
        customizeMenuItem.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            if (this.perspSwitcherToolbar.isDisposed()) {
                return;
            }
            IHandlerService handlerService = (IHandlerService)workbenchWindow.getService(IHandlerService.class);
            IStatus status = Status.OK_STATUS;
            try {
                handlerService.executeCommand("org.eclipse.ui.window.customizePerspective", null);
            }
            catch (ExecutionException | NotEnabledException | NotDefinedException e) {
                status = new Status(4, "org.eclipse.ui", e.getMessage(), e);
            }
            catch (NotHandledException notHandledException) {}
            if (!status.isOK()) {
                StatusManager.getManager().handle(status, 3);
            }
        }));
    }

    private void addShowTextItem(Menu menu) {
        MenuItem showtextMenuItem = new MenuItem(menu, 32);
        showtextMenuItem.setText(WorkbenchMessages.PerspectiveBar_showText);
        IPreferenceStore apiPreferenceStore = PrefUtil.getAPIPreferenceStore();
        String showTextOnPerspectiveBarPreference = "SHOW_TEXT_ON_PERSPECTIVE_BAR";
        showtextMenuItem.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean preference = showtextMenuItem.getSelection();
            if (preference != apiPreferenceStore.getDefaultBoolean(showTextOnPerspectiveBarPreference)) {
                PrefUtil.getInternalPreferenceStore().setValue("overridepresentation", true);
            }
            apiPreferenceStore.setValue(showTextOnPerspectiveBarPreference, preference);
            this.changeShowText(preference);
        }));
        showtextMenuItem.setSelection(apiPreferenceStore.getBoolean(showTextOnPerspectiveBarPreference));
    }

    private void setPropertyChangeListener() {
        this.propertyChangeListener = propertyChangeEvent -> {
            if ("SHOW_TEXT_ON_PERSPECTIVE_BAR".equals(propertyChangeEvent.getProperty())) {
                Object newValue = propertyChangeEvent.getNewValue();
                boolean showText = true;
                if (newValue instanceof Boolean) {
                    showText = (Boolean)newValue;
                } else if ("false".equals(newValue)) {
                    showText = false;
                }
                this.changeShowText(showText);
            }
        };
        PrefUtil.getAPIPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
    }

    private void changeShowText(boolean showText) {
        ToolItem[] items;
        ToolItem[] toolItemArray = items = this.perspSwitcherToolbar.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem item = toolItemArray[n2];
            MPerspective persp = (MPerspective)item.getData();
            if (persp != null) {
                if (showText) {
                    if (persp.getLabel() != null) {
                        item.setText(persp.getLocalizedLabel());
                    }
                    item.setToolTipText(persp.getLocalizedTooltip());
                } else {
                    Image image = item.getImage();
                    if (image != null) {
                        item.setText("");
                        item.setToolTipText(persp.getLocalizedLabel());
                    }
                }
            }
            ++n2;
        }
        this.fixSize();
    }

    private void fixSize() {
        this.perspSwitcherToolbar.pack();
        this.perspSwitcherToolbar.getParent().pack();
        this.perspSwitcherToolbar.requestLayout();
    }

    private void removePerspectiveItem(MPerspective toRemove) {
        ToolItem psItem = this.getItemFor(toRemove);
        if (psItem != null) {
            psItem.dispose();
        }
        this.fixSize();
    }

    protected ToolItem getItemFor(MPerspective persp) {
        if (this.perspSwitcherToolbar == null) {
            return null;
        }
        ToolItem[] toolItemArray = this.perspSwitcherToolbar.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem ti = toolItemArray[n2];
            if (ti.getData() == persp) {
                return ti;
            }
            ++n2;
        }
        return null;
    }

    void dispose() {
        this.cleanUp();
    }

    void disposeTBImages() {
        ToolItem[] items;
        ToolItem[] toolItemArray = items = this.perspSwitcherToolbar.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem item = toolItemArray[n2];
            Image image = item.getImage();
            if (image != null) {
                item.setImage(null);
                image.dispose();
            }
            ++n2;
        }
    }

    private void updateToolItem(ToolItem ti, String attName, Object newValue) {
        block13: {
            boolean showText = PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_TEXT_ON_PERSPECTIVE_BAR");
            if (showText && "label".equals(attName)) {
                String newName = (String)newValue;
                ti.setText(newName);
            } else if ("tooltip".equals(attName)) {
                String newTTip = (String)newValue;
                ti.setToolTipText(newTTip);
            } else if ("iconURI".equals(attName)) {
                Image currentImage = ti.getImage();
                String uri = (String)newValue;
                URL url = null;
                try {
                    try {
                        url = new URL(uri);
                        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)url);
                        if (descriptor == null) {
                            ti.setImage(null);
                            break block13;
                        }
                        ti.setImage(descriptor.createImage());
                    }
                    catch (IOException e) {
                        ti.setImage(null);
                        this.logger.warn((Throwable)e);
                        if (currentImage != null) {
                            currentImage.dispose();
                        }
                    }
                }
                finally {
                    if (currentImage != null) {
                        currentImage.dispose();
                    }
                }
            }
        }
    }
}

