/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efbt.openregspecs.model.open_reg_specs;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AttrComparison implements Enumerator
{
    EQUALS(0, "equals", "equals"),
    LESS_THAN(1, "less_than", "less_than"),
    GREATER_THAN(2, "greater_than", "greater_than"),
    NOT_EQUALS(3, "not_equals", "not_equals");

    public static final int EQUALS_VALUE = 0;
    public static final int LESS_THAN_VALUE = 1;
    public static final int GREATER_THAN_VALUE = 2;
    public static final int NOT_EQUALS_VALUE = 3;
    private static final AttrComparison[] VALUES_ARRAY;
    public static final List<AttrComparison> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AttrComparison[]{EQUALS, LESS_THAN, GREATER_THAN, NOT_EQUALS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AttrComparison get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AttrComparison result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AttrComparison getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AttrComparison result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AttrComparison get(int value) {
        switch (value) {
            case 0: {
                return EQUALS;
            }
            case 1: {
                return LESS_THAN;
            }
            case 2: {
                return GREATER_THAN;
            }
            case 3: {
                return NOT_EQUALS;
            }
        }
        return null;
    }

    private AttrComparison(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

