/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;

public class GitURI {
    private static final String SCHEME_GIT = "git";
    private static final String KEY_PATH = "path";
    private static final String KEY_PROJECT = "project";
    private static final String KEY_TAG = "tag";
    private final URIish repository;
    private IPath path;
    private String tag;
    private String projectName;

    public GitURI(URI uri) {
        try {
            if ("scm".equals(uri.getScheme())) {
                String ssp = uri.getSchemeSpecificPart();
                int indexOfSemicolon = ssp.indexOf(59);
                if (indexOfSemicolon < 0) {
                    throw new IllegalArgumentException(NLS.bind((String)CoreText.GitURI_InvalidSCMURL, (Object[])new String[]{uri.toString()}));
                }
                if (ssp.startsWith(SCHEME_GIT)) {
                    String[] params;
                    URIish r = new URIish(ssp.substring(SCHEME_GIT.length() + 1, indexOfSemicolon));
                    Path p = null;
                    String t = "master";
                    String pn = null;
                    String[] stringArray = params = ssp.substring(indexOfSemicolon).split(";");
                    int n = params.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String param = stringArray[n2];
                        if (param.startsWith("path=")) {
                            p = new Path(param.substring(param.indexOf(61) + 1));
                        } else if (param.startsWith("tag=")) {
                            t = param.substring(param.indexOf(61) + 1);
                        } else if (param.startsWith("project=")) {
                            pn = param.substring(param.indexOf(61) + 1);
                        }
                        ++n2;
                    }
                    this.repository = r;
                    this.path = p;
                    this.tag = t;
                    this.projectName = pn;
                    return;
                }
            }
            throw new IllegalArgumentException(NLS.bind((String)CoreText.GitURI_InvalidSCMURL, (Object[])new String[]{uri.toString()}));
        }
        catch (URISyntaxException e) {
            Activator.logError(e.getMessage(), e);
            throw new IllegalArgumentException(NLS.bind((String)CoreText.GitURI_InvalidURI, (Object[])new String[]{uri.toString(), e.getMessage()}));
        }
    }

    public IPath getPath() {
        return this.path;
    }

    public URIish getRepository() {
        return this.repository;
    }

    public String getTag() {
        return this.tag;
    }

    public String getProjectName() {
        return this.projectName;
    }
}

