/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.weld.bootstrap.MissingDependenciesRegistry;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.injection.ParameterInjectionPointImpl;
import org.jboss.weld.injection.attributes.ForwardingFieldInjectionPointAttributes;
import org.jboss.weld.injection.attributes.ForwardingParameterInjectionPointAttributes;
import org.jboss.weld.injection.attributes.SpecialParameterInjectionPoint;
import org.jboss.weld.injection.attributes.WeldInjectionPointAttributes;
import org.jboss.weld.logging.ValidatorLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.util.reflection.Reflections;

public class InjectionPoints {
    private InjectionPoints() {
    }

    public static <T extends WeldInjectionPointAttributes<?, ?>> Set<T> flattenInjectionPoints(List<? extends Set<T>> fieldInjectionPoints) {
        HashSet<T> injectionPoints = new HashSet<T>();
        for (Set<T> i : fieldInjectionPoints) {
            injectionPoints.addAll(i);
        }
        return injectionPoints;
    }

    public static Set<ParameterInjectionPoint<?, ?>> flattenParameterInjectionPoints(List<Set<MethodInjectionPoint<?, ?>>> methodInjectionPoints) {
        HashSet injectionPoints = new HashSet();
        for (Set<MethodInjectionPoint<?, ?>> i : methodInjectionPoints) {
            for (MethodInjectionPoint<?, ?> method : i) {
                for (ParameterInjectionPoint parameter : method.getParameterInjectionPoints()) {
                    injectionPoints.add(parameter);
                }
            }
        }
        return injectionPoints;
    }

    public static <X> Set<InjectionPoint> filterOutSpecialParameterInjectionPoints(List<ParameterInjectionPoint<?, X>> injectionPoints) {
        ImmutableSet.Builder<ParameterInjectionPoint<?, X>> filtered = ImmutableSet.builder();
        for (ParameterInjectionPoint<?, X> parameter : injectionPoints) {
            if (parameter instanceof SpecialParameterInjectionPoint) continue;
            filtered.add(parameter);
        }
        return filtered.build();
    }

    public static <T, X> WeldInjectionPointAttributes<T, ?> getWeldInjectionPoint(InjectionPoint injectionPoint) {
        if (injectionPoint instanceof WeldInjectionPointAttributes) {
            return (WeldInjectionPointAttributes)Reflections.cast(injectionPoint);
        }
        if (injectionPoint.getAnnotated() instanceof AnnotatedField) {
            return FieldInjectionPoint.silent(ForwardingFieldInjectionPointAttributes.of(injectionPoint));
        }
        return ParameterInjectionPointImpl.silent(ForwardingParameterInjectionPointAttributes.of(injectionPoint));
    }

    public static boolean isInjectableReferenceLookupOptimizationAllowed(Bean<?> bean, Bean<?> resolvedBean) {
        Preconditions.checkArgumentNotNull(resolvedBean, "resolvedBean");
        return bean != null && (RequestScoped.class.equals((Object)bean.getScope()) && Beans.hasBuiltinScope(resolvedBean) || ApplicationScoped.class.equals((Object)bean.getScope()) && ApplicationScoped.class.equals((Object)resolvedBean.getScope()));
    }

    public static String getUnsatisfiedDependenciesAdditionalInfo(InjectionPoint ij, BeanManagerImpl beanManager) {
        Set<Bean<?>> beansMatchedByType = beanManager.getBeans(ij.getType(), new Annotation[]{Any.Literal.INSTANCE});
        if (beansMatchedByType.isEmpty()) {
            MissingDependenciesRegistry missingDependenciesRegistry;
            String missingDependency;
            Class rawType = Reflections.getRawType(ij.getType());
            if (rawType != null && (missingDependency = (missingDependenciesRegistry = beanManager.getServices().get(MissingDependenciesRegistry.class)).getMissingDependencyForClass(rawType.getName())) != null) {
                return ValidatorLogger.LOG.unsatisfiedDependencyBecauseClassIgnored(rawType.getName(), missingDependency);
            }
        } else {
            return ValidatorLogger.LOG.unsatisfiedDependencyBecauseQualifiersDontMatch(WeldCollections.toMultiRowString(beansMatchedByType));
        }
        return "";
    }
}

