/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.module;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resources.admin.cli.SunResourcesXML;
import org.glassfish.resources.api.Resource;

public class ResourceUtilities {
    private static final Logger _logger = LogDomains.getLogger(ResourceUtilities.class, (String)"jakarta.enterprise.resource.resourceadapter");
    private static final StringManager localStrings = StringManager.getManager(ResourceUtilities.class);

    private ResourceUtilities() {
    }

    private static SimpleJndiName getIdToCompare(Resource res) {
        HashMap attrs = res.getAttributes();
        String type = res.getType();
        String id = "jdbc-connection-pool".equals(type) || "connector-connection-pool".equals(type) ? ResourceUtilities.getNamedAttributeValue(attrs, "name") : ("security-map".equals(type) ? ResourceUtilities.getNamedAttributeValue(attrs, "name") : ("resource-adapter-config".equals(type) ? ResourceUtilities.getNamedAttributeValue(attrs, "resource-adapter-name") : ("work-security-map".equals(type) ? ResourceUtilities.getNamedAttributeValue(attrs, "name") : ResourceUtilities.getNamedAttributeValue(attrs, "jndi-name"))));
        return SimpleJndiName.of((String)id);
    }

    private static String getNamedAttributeValue(HashMap attributes, String name) {
        return (String)attributes.get(name);
    }

    public static Set<Resource> resolveResourceDuplicatesConflictsWithinArchive(List<SunResourcesXML> sunResList) throws ResourceConflictException {
        StringBuffer conflictingResources = new StringBuffer();
        HashSet<Resource> resourceSet = new HashSet<Resource>();
        for (SunResourcesXML sunResXML : sunResList) {
            List resources = sunResXML.getResourcesList();
            for (Resource res : resources) {
                boolean addResource = true;
                for (Resource existingRes : resourceSet) {
                    if (existingRes.equals((Object)res)) {
                        addResource = false;
                        _logger.warning(localStrings.getString("duplicate.resource.sun.resource.xml", (Object)ResourceUtilities.getIdToCompare(res), (Object)sunResXML.getXMLPath()));
                        break;
                    }
                    if (!existingRes.isAConflict(res)) continue;
                    addResource = false;
                    conflictingResources.append("\n");
                    String message = localStrings.getString("conflict.resource.sun.resource.xml", (Object)ResourceUtilities.getIdToCompare(res), (Object)sunResXML.getXMLPath());
                    conflictingResources.append(message);
                    _logger.warning(message);
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    ResourceUtilities.logAttributes(res);
                }
                if (!addResource) continue;
                resourceSet.add(res);
            }
        }
        if (conflictingResources.toString().length() > 0) {
            throw new ResourceConflictException(conflictingResources.toString());
        }
        return resourceSet;
    }

    private static void logAttributes(Resource res) {
        StringBuilder message = new StringBuilder();
        Set entries = res.getAttributes().entrySet();
        for (Map.Entry entry : entries) {
            message.append(entry.getKey());
            message.append("=");
            message.append(entry.getValue());
            message.append(" ");
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(localStrings.getString("resource.attributes", (Object)message.toString()));
        }
    }
}

