/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.sse.impl;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.glassfish.sse.api.ServerSentEventConnection;
import org.glassfish.sse.api.ServerSentEventData;
import org.glassfish.sse.api.ServerSentEventHandler;
import org.glassfish.sse.impl.ServerSentEventApplication;

final class ServerSentEventConnectionImpl
extends ServerSentEventConnection
implements AsyncListener {
    final HttpServletRequest request;
    final ServerSentEventHandler sseh;
    final AsyncContext asyncContext;
    final CreationalContext<?> cc;
    private final ServerSentEventApplication owner;
    private boolean closed;

    ServerSentEventConnectionImpl(ServerSentEventApplication owner, HttpServletRequest request, ServerSentEventHandler sseh, CreationalContext<?> cc, AsyncContext asyncContext) {
        this.owner = owner;
        this.request = request;
        this.sseh = sseh;
        this.cc = cc;
        this.asyncContext = asyncContext;
    }

    void init() {
        this.sseh.onConnected(this);
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public void sendMessage(String eventData) throws IOException {
        this.sendMessage(new ServerSentEventData().data(eventData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(ServerSentEventData eventData) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("sendMessage cannot be called after the connection is closed.");
        }
        ServerSentEventHandler serverSentEventHandler = this.sseh;
        synchronized (serverSentEventHandler) {
            try {
                HttpServletResponse res = (HttpServletResponse)this.asyncContext.getResponse();
                ServletOutputStream sos = res.getOutputStream();
                sos.write(eventData.toString().getBytes("UTF-8"));
                sos.write(10);
                sos.flush();
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void close() {
        this.closed = true;
        this.destroy();
    }

    @Override
    public void onComplete(AsyncEvent event) throws IOException {
    }

    @Override
    public void onTimeout(AsyncEvent event) throws IOException {
    }

    @Override
    public void onError(AsyncEvent event) throws IOException {
        this.destroy();
    }

    @Override
    public void onStartAsync(AsyncEvent event) throws IOException {
    }

    private void destroy() {
        this.cc.release();
        this.owner.destroyConnection(this);
        this.asyncContext.complete();
    }
}

