/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.util;

import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import org.shoal.ha.cache.impl.util.Utility;

public class ReplicationInputStream
extends ByteArrayInputStream {
    private int minPos = 0;
    private int maxPos = -1;

    public ReplicationInputStream(byte[] data) {
        super(data);
        this.maxPos = data.length - 1;
    }

    public ReplicationInputStream(byte[] data, int offset, int len) {
        super(data, offset, len);
        this.minPos = offset;
        this.maxPos = offset + len - 1;
    }

    public int mark() {
        super.mark(0);
        return this.pos;
    }

    public void skipTo(int index) {
        if (index < this.minPos || index > this.maxPos) {
            throw new IllegalArgumentException("Illegal position (" + index + "). Valid values are from " + this.minPos + " to " + this.maxPos);
        }
        this.pos = index;
    }

    public final int readInt() {
        int val = Utility.bytesToInt(this.buf, this.pos);
        this.pos += 4;
        return val;
    }

    public final long readLong() {
        return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    public final String readLengthPrefixedString() {
        String str = null;
        int len = this.readInt();
        if (len > 0) {
            str = new String(this.buf, this.pos, len, Charset.defaultCharset());
            this.pos += len;
        }
        return str;
    }

    public final byte[] readLengthPrefixedBytes() {
        byte[] data = null;
        int len = this.readInt();
        if (len > 0) {
            data = new byte[len];
            System.arraycopy(this.buf, this.pos, data, 0, len);
            this.pos += len;
        }
        return data;
    }

    public boolean readBoolean() {
        return this.buf[this.pos++] == 1;
    }

    public byte[] getBuffer() {
        return this.buf;
    }
}

