/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.data;

import com.sun.enterprise.config.serverbeans.ApplicationConfig;
import com.sun.enterprise.config.serverbeans.Engine;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import org.glassfish.api.ActionReport;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.internal.data.EngineInfo;
import org.glassfish.internal.data.ProgressTracker;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.config.TransactionFailure;

public class EngineRef {
    private final EngineInfo<?, ?> engineInfo;
    private ApplicationContainer<?> applicationContainer;
    private ApplicationConfig appConfig;

    public EngineRef(EngineInfo<?, ?> container, ApplicationContainer<?> appCtr) {
        this.engineInfo = container;
        this.applicationContainer = appCtr;
    }

    public EngineInfo<?, ?> getContainerInfo() {
        return this.engineInfo;
    }

    public void setApplicationContainer(ApplicationContainer<?> applicationContainer) {
        this.applicationContainer = applicationContainer;
    }

    public ApplicationContainer<?> getApplicationContainer() {
        return this.applicationContainer;
    }

    public void setApplicationConfig(ApplicationConfig config) {
        this.appConfig = config;
    }

    public ApplicationConfig getApplicationConfig() {
        return this.appConfig;
    }

    public void load(ExtendedDeploymentContext context, ProgressTracker tracker) {
        this.getContainerInfo().load(context);
        tracker.add("loaded", EngineRef.class, this);
    }

    public boolean start(ApplicationContext context, ProgressTracker tracker) throws Exception {
        if (this.applicationContainer == null) {
            return true;
        }
        if (!this.applicationContainer.start(context)) {
            return false;
        }
        tracker.add("started", EngineRef.class, this);
        return true;
    }

    public boolean unload(ExtendedDeploymentContext context) {
        ActionReport report = context.getActionReport();
        Deployer<?, ?> deployer = this.engineInfo.getDeployer();
        try {
            deployer.unload(this.applicationContainer, (DeploymentContext)context);
            this.engineInfo.unload(context);
        }
        catch (Exception e) {
            report.failure(context.getLogger(), "Exception while shutting down application container", (Throwable)e);
            return false;
        }
        this.applicationContainer = null;
        return true;
    }

    public boolean stop(ApplicationContext context) {
        return this.applicationContainer.stop(context);
    }

    public void clean(ExtendedDeploymentContext context) {
        try {
            this.getContainerInfo().clean(context);
        }
        catch (Exception e) {
            context.getLogger().log(Level.WARNING, "Exception while cleaning module '" + String.valueOf(this) + "'" + String.valueOf(e), e);
        }
    }

    public void save(Engine engine) throws TransactionFailure, PropertyVetoException {
        engine.setSniffer(this.getContainerInfo().getSniffer().getModuleType());
        if (this.appConfig != null) {
            engine.setApplicationConfig(this.appConfig);
        }
    }

    public String toString() {
        return String.valueOf(this.engineInfo) + ", " + super.toString();
    }
}

