/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.parser;

import com.sun.enterprise.server.logging.parser.LogParser;
import com.sun.enterprise.server.logging.parser.LogParserException;
import com.sun.enterprise.server.logging.parser.LogParserListener;
import com.sun.enterprise.server.logging.parser.ParsedLogRecord;
import java.io.BufferedReader;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.main.jul.formatter.ExcludeFieldsSupport;

final class ODLLogParser
implements LogParser {
    private static final int FIXED_FIELD_COUNT = 5;
    private static final Pattern RECORD_START = Pattern.compile("^\\[[0-9]{4}\\-[0-9]{2}\\-[0-9]{2}T\\d\\d:\\d\\d:\\d\\d\\.[\\d]{3,9}([0-9:+-]{5,8}|Z)\\].*");
    private static final Pattern FIELD = Pattern.compile("(\\[[^\\[\\]\n]*\\])+");
    private static final Pattern THREAD_FIELD = Pattern.compile("[^_]*_ThreadID=(.+) _ThreadName=(.+)");

    ODLLogParser() {
    }

    @Override
    public void parseLog(BufferedReader reader, LogParserListener listener) throws LogParserException {
        String line = null;
        try {
            StringBuilder buffer = new StringBuilder();
            long position = 0L;
            while ((line = reader.readLine()) != null) {
                Matcher m = RECORD_START.matcher(line);
                if (m.matches()) {
                    String logRecord = buffer.toString();
                    buffer.setLength(0);
                    this.process(position, logRecord, listener);
                    position += (long)logRecord.length();
                }
                buffer.append(line);
                buffer.append(System.lineSeparator());
            }
            String logRecord = buffer.toString();
            this.process(position, logRecord, listener);
        }
        catch (IOException e) {
            throw new LogParserException(line, e);
        }
    }

    private void process(long position, String logRecord, LogParserListener listener) {
        ParsedLogRecord parsedLogRecord = this.parse(logRecord);
        if (parsedLogRecord != null) {
            listener.foundLogRecord(position, parsedLogRecord);
        }
    }

    private ParsedLogRecord parse(String logRecord) {
        int endIndex;
        if (!logRecord.startsWith("[")) {
            return null;
        }
        ParsedLogRecord parsedLogRecord = new ParsedLogRecord(logRecord);
        Matcher matcher = FIELD.matcher(logRecord);
        int start = 0;
        int end = 0;
        int fieldIndex = 0;
        while (matcher.find()) {
            ++fieldIndex;
            start = matcher.start();
            if (end != 0 && start != end + 1) break;
            end = matcher.end();
            String text = matcher.group();
            text = text.substring(1, text.length() - 1);
            if (fieldIndex <= 5) {
                this.populateLogRecordFields(fieldIndex, text, parsedLogRecord);
                continue;
            }
            this.populateLogRecordSuppAttrs(text, parsedLogRecord);
        }
        String msg = logRecord.substring(end).trim();
        boolean multiLineBegin = false;
        if (msg.startsWith("[[")) {
            msg = msg.replaceFirst("\\[\\[", "").trim();
            multiLineBegin = true;
        }
        if (multiLineBegin && msg.endsWith("]]") && (endIndex = msg.length() - 2) > 0) {
            msg = msg.substring(0, endIndex);
        }
        parsedLogRecord.setMessage(msg);
        if (fieldIndex < 5) {
            return null;
        }
        return parsedLogRecord;
    }

    private void populateLogRecordSuppAttrs(String text, ParsedLogRecord parsedLogRecord) {
        int index = text.indexOf(58);
        if (index > 0) {
            String key = text.substring(0, index);
            String value = text.substring(index + 1).trim();
            if (ExcludeFieldsSupport.SupplementalAttribute.TID.getId().equals(key)) {
                Matcher matcher = THREAD_FIELD.matcher(value);
                if (matcher.find()) {
                    parsedLogRecord.setThreadId(LogParser.toLong(matcher.group(1)));
                    parsedLogRecord.setThreadName(matcher.group(2));
                }
            } else if (ExcludeFieldsSupport.SupplementalAttribute.LEVEL_VALUE.getId().equals(key)) {
                parsedLogRecord.setLogLevelValue(LogParser.toInteger(value));
            } else {
                parsedLogRecord.setSupplementalValue(key, value);
            }
        }
    }

    private void populateLogRecordFields(int index, String fieldData, ParsedLogRecord parsedLogRecord) {
        switch (index) {
            case 1: {
                parsedLogRecord.setTimestamp(OffsetDateTime.parse(fieldData, ISO_OFFSET_DATE_TIME_PARSER));
                break;
            }
            case 2: {
                parsedLogRecord.setProductId(fieldData);
                break;
            }
            case 3: {
                parsedLogRecord.setLogLevel(fieldData);
                break;
            }
            case 4: {
                parsedLogRecord.setMessageKey(fieldData);
                break;
            }
            case 5: {
                parsedLogRecord.setLogger(fieldData);
                break;
            }
        }
    }
}

