/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class Node {
    private static final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    protected static final ReentrantReadWriteLock.ReadLock readLock = lock.readLock();
    protected static final ReentrantReadWriteLock.WriteLock writeLock = lock.writeLock();
    protected final int id;
    protected Node next;
    protected Node prev;
    protected Node parent;
    protected Node firstChild;
    protected boolean exclusive;

    protected Node(int id) {
        this.id = id;
    }

    protected void exclusive() {
        writeLock.lock();
        try {
            Node p = this.parent;
            p.detach(this.id);
            p.addChild(this, true);
        }
        finally {
            writeLock.unlock();
        }
    }

    protected void addSibling(Node sibling) {
        writeLock.lock();
        try {
            sibling.next = this;
            this.prev = sibling;
            sibling.parent = this.parent;
            this.parent.firstChild = sibling;
        }
        finally {
            writeLock.unlock();
        }
    }

    protected void addChild(Node n) {
        this.addChild(n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChild(Node nodeBeingAddedAsChild, boolean exclusive) {
        writeLock.lock();
        try {
            if (exclusive) {
                nodeBeingAddedAsChild.exclusive = true;
                if (nodeBeingAddedAsChild.firstChild != null && this.firstChild != null) {
                    Node tail = this.firstChild;
                    while (tail.next != null) {
                        tail = tail.next;
                    }
                    tail.next = nodeBeingAddedAsChild.firstChild;
                    nodeBeingAddedAsChild.firstChild.prev = tail;
                    nodeBeingAddedAsChild.firstChild = this.firstChild;
                } else if (nodeBeingAddedAsChild.firstChild == null && this.firstChild != null) {
                    nodeBeingAddedAsChild.firstChild = this.firstChild;
                }
                this.firstChild = null;
                if (nodeBeingAddedAsChild.firstChild != null) {
                    Node t = nodeBeingAddedAsChild.firstChild;
                    do {
                        t.parent = nodeBeingAddedAsChild;
                    } while ((t = t.next) != null);
                }
            }
            if (this.firstChild == null) {
                this.firstChild = nodeBeingAddedAsChild;
                this.firstChild.parent = this;
            } else {
                this.firstChild.addSibling(nodeBeingAddedAsChild);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    protected Node detach(int id) {
        return this.remove(id, true);
    }

    protected Node remove(int id) {
        return this.remove(id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node find(int id) {
        if (this.id == id) {
            return this;
        }
        readLock.lock();
        try {
            if (this.firstChild != null) {
                Node n = this.firstChild;
                do {
                    if (n.id == id) {
                        Node node = n;
                        return node;
                    }
                    Node result = n.find(id);
                    if (result == null) continue;
                    Node node = result;
                    return node;
                } while ((n = n.next) != null);
            }
            Node node = null;
            return node;
        }
        finally {
            readLock.unlock();
        }
    }

    private boolean isFirstSibling() {
        return this.next != null && this.prev == null;
    }

    private boolean isLastSibling() {
        return this.next == null && this.prev != null;
    }

    private boolean hasSiblings() {
        return this.next != null || this.prev != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node remove(int id, boolean retainChildren) {
        Node n = this.find(id);
        if (n != null) {
            writeLock.lock();
            try {
                if (n.hasSiblings()) {
                    Node left = n.prev;
                    Node right = n.next;
                    if (n.isFirstSibling()) {
                        right.parent.firstChild = right;
                        right.prev = null;
                    } else if (n.isLastSibling()) {
                        left.next = null;
                    } else {
                        left.next = right;
                        right.prev = left;
                    }
                }
                if (!retainChildren) {
                    Node np = n.parent;
                    if (n.firstChild != null) {
                        Node t = n.firstChild;
                        Node last = null;
                        do {
                            t.parent = np;
                            if (t.next != null) continue;
                            last = t;
                        } while ((t = t.next) != null);
                        last.next = np.firstChild;
                        np.firstChild.prev = last;
                        np.firstChild = n.firstChild;
                    }
                }
                n.parent = null;
                n.next = null;
                n.prev = null;
                if (!retainChildren) {
                    n.firstChild = null;
                }
                Node node = n;
                return node;
            }
            finally {
                writeLock.unlock();
            }
        }
        return null;
    }
}

