/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.interceptors;

import com.sun.corba.ee.impl.interceptors.PICurrent;
import com.sun.corba.ee.impl.interceptors.SlotTable;
import com.sun.corba.ee.spi.logging.InterceptorsSystemException;
import com.sun.corba.ee.spi.orb.ORB;
import java.util.ArrayList;
import java.util.List;

public class SlotTableStack {
    private static final InterceptorsSystemException wrapper = InterceptorsSystemException.self;
    private List<SlotTable> tableContainer;
    private int currentIndex;
    private ORB orb;
    private PICurrent current;

    SlotTableStack(ORB orb, PICurrent current) {
        this.current = current;
        this.orb = orb;
        this.currentIndex = 0;
        this.tableContainer = new ArrayList<SlotTable>();
        this.pushSlotTable();
    }

    void pushSlotTable() {
        SlotTable table = new SlotTable(this.orb, this.current.getTableSize());
        if (this.currentIndex == this.tableContainer.size()) {
            this.tableContainer.add(this.currentIndex, table);
        } else {
            if (this.currentIndex > this.tableContainer.size()) {
                throw wrapper.slotTableInvariant(this.currentIndex, this.tableContainer.size());
            }
            this.tableContainer.set(this.currentIndex, table);
        }
        ++this.currentIndex;
    }

    void popSlotTable() {
        if (this.currentIndex == 1) {
            throw wrapper.cantPopOnlyPicurrent();
        }
        --this.currentIndex;
        SlotTable table = this.tableContainer.get(this.currentIndex);
        this.tableContainer.set(this.currentIndex, null);
        table.resetSlots();
    }

    SlotTable peekSlotTable() {
        SlotTable result = this.tableContainer.get(this.currentIndex - 1);
        if (result.getSize() != this.current.getTableSize()) {
            result = new SlotTable(this.orb, this.current.getTableSize());
            this.tableContainer.set(this.currentIndex - 1, result);
        }
        return result;
    }
}

