/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.Locale;
import java.util.logging.Level;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.util.Base64;

public class BasicAuthenticator
extends AuthenticatorBase {
    protected static final String info = "org.apache.catalina.authenticator.BasicAuthenticator/1.0";

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    protected String getAuthMethod() {
        return "BASIC";
    }

    @Override
    public boolean authenticate(HttpRequest request, HttpResponse response, LoginConfig config) throws IOException {
        String realmName;
        Principal existingPrincipal = ((HttpServletRequest)request.getRequest()).getUserPrincipal();
        if (existingPrincipal != null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Already authenticated '" + existingPrincipal.getName() + "'");
            }
            return true;
        }
        HttpServletResponse httpServletResponse = (HttpServletResponse)response.getResponse();
        String authorization = request.getAuthorization();
        if (authorization != null) {
            String username = this.parseUsername(authorization);
            char[] password = this.parsePassword(authorization);
            Principal authenticatedPrincipal = this.context.getRealm().authenticate(request, username, password);
            if (authenticatedPrincipal != null) {
                this.register(request, response, authenticatedPrincipal, "BASIC", username, password);
                String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
                if (ssoId != null) {
                    this.getSession(request, true);
                }
                return true;
            }
        }
        if ((realmName = config.getRealmName()) == null) {
            realmName = "Authentication required";
        }
        httpServletResponse.setHeader("WWW-Authenticate", "Basic realm=\"" + realmName + "\"");
        httpServletResponse.sendError(401);
        return false;
    }

    protected String parseUsername(String authorization) {
        if (!BasicAuthenticator.isBasicAuthHeader(authorization)) {
            return null;
        }
        String unencoded = new String(Base64.decode((authorization = authorization.substring(6).trim()).getBytes(Charset.defaultCharset())));
        int colon = unencoded.indexOf(58);
        if (colon < 0) {
            return null;
        }
        return unencoded.substring(0, colon);
    }

    protected char[] parsePassword(String authorization) {
        if (!BasicAuthenticator.isBasicAuthHeader(authorization)) {
            return null;
        }
        String unencoded = new String(Base64.decode((authorization = authorization.substring(6).trim()).getBytes(Charset.defaultCharset())));
        int colon = unencoded.indexOf(58);
        if (colon < 0) {
            return null;
        }
        return unencoded.substring(colon + 1).toCharArray();
    }

    private static boolean isBasicAuthHeader(String authorization) {
        return authorization != null && authorization.toLowerCase(Locale.ENGLISH).startsWith("basic ");
    }
}

