/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.glassfish.bootstrap.cfg.StartupContextUtil;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.security.store.IdentityManagement;
import jakarta.inject.Inject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Logger;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.security.services.impl.JCEKSPasswordAliasStore;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Service;

@Service(name="jks-based")
public class IdmService
implements PostConstruct,
IdentityManagement {
    private final Logger logger = Logger.getAnonymousLogger();
    @Inject
    private volatile StartupContext sc = null;
    @Inject
    private volatile ServerEnvironmentImpl env = null;
    private char[] masterPassword;
    private static final String FIXED_KEY = "master-password";
    private static final String PASSWORDFILE_OPTION_TO_ASMAIN = "-passwordfile";
    private static final String STDIN_OPTION_TO_ASMAIN = "-read-stdin";
    private static final String MP_PROPERTY = "AS_ADMIN_MASTERPASSWORD";

    public void postConstruct() {
        boolean success;
        boolean readStdin = this.sc.getArguments().containsKey(STDIN_OPTION_TO_ASMAIN);
        if (readStdin) {
            success = this.setFromStdin();
        } else {
            success = this.setFromMasterPasswordFile();
            if (!success) {
                success = this.setFromAsMainArguments();
            }
        }
        if (!success) {
            this.masterPassword = "changeit".toCharArray();
        }
    }

    public char[] getMasterPassword() {
        return Arrays.copyOf(this.masterPassword, this.masterPassword.length);
    }

    private boolean setFromMasterPasswordFile() {
        try {
            File mp = this.env.getMasterPasswordFile();
            if (!mp.isFile()) {
                this.logger.fine("The JCEKS file: " + mp.getAbsolutePath() + " does not exist, master password was not saved on disk during domain creation");
                return false;
            }
            JCEKSPasswordAliasStore masterPasswordAliasStore = JCEKSPasswordAliasStore.newInstance((String)mp.getAbsolutePath(), (char[])FIXED_KEY.toCharArray());
            char[] mpChars = masterPasswordAliasStore.get(FIXED_KEY);
            if (mpChars == null) {
                return false;
            }
            this.masterPassword = mpChars;
            return true;
        }
        catch (Exception ex) {
            this.logger.fine("Error in master-password processing: " + ex.getMessage());
            return false;
        }
    }

    private boolean setFromAsMainArguments() {
        File pwf = null;
        try {
            String[] args = StartupContextUtil.getOriginalArguments((StartupContext)this.sc);
            int index = 0;
            for (String arg : args) {
                if (PASSWORDFILE_OPTION_TO_ASMAIN.equals(arg)) {
                    if (index == args.length - 1) {
                        this.logger.warning("NCLS-CORE-00077");
                        return false;
                    }
                    pwf = new File(args[index + 1]);
                    return this.readPasswordFile(pwf);
                }
                ++index;
            }
            return false;
        }
        catch (Exception ex) {
            String s = "Something wrong with given password file: ";
            String msg = pwf == null ? s : s + pwf.getAbsolutePath();
            this.logger.fine(msg);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readPasswordFile(File pwf) {
        Properties p = new Properties();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(pwf));
            p.load(br);
            if (p.getProperty(MP_PROPERTY) == null) {
                boolean bl = false;
                return bl;
            }
            this.masterPassword = p.getProperty(MP_PROPERTY).toCharArray();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.logger.fine("Passwordfile: " + pwf.getAbsolutePath() + " (a simple property file) could not be processed, ignoring ...");
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private boolean setFromStdin() {
        this.logger.fine("Reading the master password from stdin> ");
        try {
            String s;
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            while ((s = br.readLine()) != null) {
                int ind = s.indexOf(MP_PROPERTY);
                if (ind == -1) {
                    return false;
                }
                this.masterPassword = s.substring(MP_PROPERTY.length() + 1).toCharArray();
            }
            return this.masterPassword != null;
        }
        catch (Exception e) {
            this.logger.fine("Stdin isn't behaving, ignoring it ..." + e.getMessage());
            return false;
        }
    }
}

