/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.monitoring.stats;

import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.monitoring.stats.EjbCacheStatsProviderDelegate;
import com.sun.ejb.monitoring.stats.EjbMonitoringUtils;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.RangeStatistic;
import org.glassfish.external.statistics.impl.BoundedRangeStatisticImpl;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="bean-cache-mon", group="monitoring", isSingleton=false)
@ManagedObject
@Description(value="Bean Cache Statistics")
public class EjbCacheStatsProvider {
    private CountStatisticImpl expiredSessionsRemovedStat = new CountStatisticImpl("NumExpiredSessionsRemoved", "count", "Provides a count value reflecting the number of expired sessions that were removed from the bean cache.");
    private CountStatisticImpl passivations = new CountStatisticImpl("NumPassivations", "count", "Provides a count value reflecting the number of passivations for a StatefulSessionBean from the bean cache.");
    private CountStatisticImpl passivationErrors = new CountStatisticImpl("NumPassivationErrors", "count", "Provides a count value reflecting the number of errors that occured while passivating a StatefulSessionBean from the bean cache.");
    private CountStatisticImpl passivationSuccess = new CountStatisticImpl("NumPassivationSuccess", "count", "Provides a count value reflecting the number of passivations for a StatefulSessionBean from the bean cache that succeeded");
    private BoundedRangeStatisticImpl cacheHits;
    private BoundedRangeStatisticImpl cacheMisses;
    private BoundedRangeStatisticImpl numBeans;
    private static final Logger _logger = EjbContainerUtilImpl.getLogger();
    private long beanId;
    private String appName = null;
    private String moduleName = null;
    private String beanName = null;
    private boolean registered = false;
    private EjbCacheStatsProviderDelegate delegate;

    public EjbCacheStatsProvider(EjbCacheStatsProviderDelegate delegate, long beanId, String appName, String moduleName, String beanName) {
        this.delegate = delegate;
        this.beanId = beanId;
        this.appName = appName;
        this.moduleName = moduleName;
        this.beanName = beanName;
        long now = System.currentTimeMillis();
        this.numBeans = new BoundedRangeStatisticImpl(0L, 0L, 0L, (long)delegate.getMaxCacheSize(), 0L, "NumBeansInCache", "count", "Provides total number of EJBs in the associated EJB Cache.", now, now);
        this.cacheHits = new BoundedRangeStatisticImpl(0L, 0L, 0L, Long.MAX_VALUE, 0L, "CacheHits", "count", "Provides the number of times a user request hits an EJB in associated EJB cache instance", now, now);
        this.cacheMisses = new BoundedRangeStatisticImpl(0L, 0L, 0L, Long.MAX_VALUE, 0L, "CacheMisses", "count", "Provides the number of times a user request fails to find an EJB in associated EJB cache instance", now, now);
    }

    public void register() {
        String invokerId = EjbMonitoringUtils.getInvokerId(this.appName, this.moduleName, this.beanName);
        String node = EjbMonitoringUtils.registerSubComponent(this.appName, this.moduleName, this.beanName, "bean-cache", this, invokerId);
        if (node != null) {
            this.registered = true;
        }
    }

    public void unregister() {
        if (this.registered) {
            this.registered = false;
            StatsProviderManager.unregister((Object)this);
        }
    }

    @ManagedAttribute(id="cachemisses")
    @Description(value="Number of times a user request fails to find an EJB in associated EJB cache instance")
    public RangeStatistic getCacheMisses() {
        this.cacheMisses.setCurrent((long)this.delegate.getCacheMisses());
        return this.cacheMisses;
    }

    @ManagedAttribute(id="cachehits")
    @Description(value="Number of times a user request hits an EJB in associated EJB cache instance")
    public RangeStatistic getCacheHits() {
        this.cacheHits.setCurrent((long)this.delegate.getCacheHits());
        return this.cacheHits;
    }

    @ManagedAttribute(id="numbeansincache")
    @Description(value="Number of EJBs in the associated EJB Cache")
    public RangeStatistic getNumBeansInCache() {
        this.numBeans.setCurrent((long)this.delegate.getNumBeansInCache());
        return this.numBeans;
    }

    @ManagedAttribute(id="numexpiredsessionsremoved")
    @Description(value="Number of expired sessions removed by the cleanup thread.")
    public CountStatistic getNumExpiredSessionsRemoved() {
        return this.expiredSessionsRemovedStat;
    }

    @ManagedAttribute(id="numpassivations")
    @Description(value="Number of passivated beans")
    public CountStatistic getNumPassivations() {
        return this.passivations;
    }

    @ManagedAttribute(id="numpassivationerrors")
    @Description(value="Number of errors during passivation.")
    public CountStatistic getNumPassivationErrors() {
        return this.passivationErrors;
    }

    @ManagedAttribute(id="numpassivationsuccess")
    @Description(value="Number of times passivation completed successfully.")
    public CountStatistic getNumPassivationSuccess() {
        return this.passivationSuccess;
    }

    @ProbeListener(value="glassfish:ejb:cache:beanPassivatedEvent")
    public void ejbBeanPassivatedEvent(@ProbeParam(value="beanId") long beanId, @ProbeParam(value="appName") String appName, @ProbeParam(value="modName") String modName, @ProbeParam(value="ejbName") String ejbName, @ProbeParam(value="success") boolean success) {
        if (this.beanId == beanId) {
            this.passivations.increment();
            if (success) {
                this.passivationSuccess.increment();
            } else {
                this.passivationErrors.increment();
            }
        }
    }

    @ProbeListener(value="glassfish:ejb:cache:expiredSessionsRemovedEvent")
    public void ejbExpiredSessionsRemovedEvent(@ProbeParam(value="beanId") long beanId, @ProbeParam(value="appName") String appName, @ProbeParam(value="modName") String modName, @ProbeParam(value="ejbName") String ejbName, @ProbeParam(value="num") long num) {
        if (this.beanId == beanId) {
            this.expiredSessionsRemovedStat.increment(num);
        }
    }
}

