/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.work;

import com.sun.enterprise.connectors.work.LogFacade;
import com.sun.enterprise.connectors.work.WorkCoordinator;
import jakarta.resource.spi.work.Work;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.logging.annotation.LogMessageInfo;

public final class OneWork
implements com.sun.corba.ee.spi.threadpool.Work {
    private final Work work;
    private final WorkCoordinator coordinator;
    private long nqTime;
    private static final Logger logger = LogFacade.getLogger();
    private String name = "Resource adapter work";
    private boolean nameSet = false;
    private ClassLoader tcc = null;
    @LogMessageInfo(message="The Work named [ {0} ], progress [ {1} ].", comment="Print Work status", level="INFO", publish=false)
    private static final String RAR_WORK_PROGRESS_INFO = "AS-RAR-05004";

    OneWork(Work work, WorkCoordinator coordinator, ClassLoader tcc) {
        this.work = work;
        this.coordinator = coordinator;
        this.tcc = tcc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork() {
        ClassLoader callerCL = Thread.currentThread().getContextClassLoader();
        if (this.tcc != null && this.tcc != callerCL) {
            Thread.currentThread().setContextClassLoader(this.tcc);
        }
        try {
            this.coordinator.preInvoke();
            boolean timedOut = this.coordinator.isTimedOut();
            if (this.coordinator.proceed()) {
                try {
                    this.coordinator.setupContext(this);
                    this.log("Start of Work");
                }
                catch (Throwable e) {
                    this.coordinator.setException(e);
                }
            }
            if (this.coordinator.proceed()) {
                try {
                    this.work.run();
                    this.log("Work Executed");
                }
                catch (Throwable t) {
                    this.log("Execution has thrown exception " + t.getMessage());
                    this.coordinator.setException(t);
                }
            }
            if (!timedOut) {
                this.coordinator.postInvoke();
            }
            this.log("End of Work");
        }
        finally {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl != callerCL) {
                Thread.currentThread().setContextClassLoader(callerCL);
            }
            this.tcc = null;
        }
    }

    public void log(String message) {
        if (this.nameSet) {
            Object[] args = new Object[]{this.name, message};
            logger.log(Level.INFO, RAR_WORK_PROGRESS_INFO, args);
        }
    }

    public void setEnqueueTime(long tme) {
        this.nqTime = tme;
    }

    public long getEnqueueTime() {
        return this.nqTime;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.nameSet = true;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.nameSet) {
            result.append("[Work : " + this.name + "] ");
        }
        result.append(this.work.toString());
        return result.toString();
    }
}

