/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.ITestContext;
import org.testng.collections.Lists;
import org.testng.collections.Maps;

class InstanceOrderingMethodInterceptor
implements IMethodInterceptor {
    InstanceOrderingMethodInterceptor() {
    }

    @Override
    public List<IMethodInstance> intercept(List<IMethodInstance> methods, ITestContext context) {
        return this.groupMethodsByInstance(methods);
    }

    private List<IMethodInstance> groupMethodsByInstance(List<IMethodInstance> methods) {
        List instanceList = Lists.newArrayList();
        Map map = Maps.newHashMap();
        for (IMethodInstance mi : methods) {
            Object[] methodInstances;
            for (Object instance : methodInstances = mi.getInstances()) {
                List l;
                if (!instanceList.contains(instance)) {
                    instanceList.add(instance);
                }
                if ((l = (List)map.get(instance)) == null) {
                    l = Lists.newArrayList();
                    map.put(instance, l);
                }
                l.add(mi);
            }
        }
        List<IMethodInstance> result = Lists.newArrayList();
        for (Object instance : instanceList) {
            result.addAll((Collection)map.get(instance));
        }
        return result;
    }
}

