/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.constraintdefinition;

import java.util.Set;
import javax.validation.Validator;
import javax.validation.constraints.Size;
import javax.validation.groups.Default;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintdefinition.AlwaysValid;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintdefinition.Movie;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintdefinition.Person;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ConstraintDefinitionsTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)ConstraintDefinitionsTest.webArchiveBuilder().withTestClassPackage(ConstraintDefinitionsTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition-properties", id="a"), @SpecAssertion(section="constraintsdefinitionimplementation-multipleconstraints", id="a")})
    public void testConstraintWithCustomAttributes() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Set descriptors = validator.getConstraintsForClass(Person.class).getConstraintsForProperty("lastName").getConstraintDescriptors();
        Assert.assertEquals((int)descriptors.size(), (int)2, (String)"There should be two constraints on the lastName property.");
        for (ConstraintDescriptor descriptor : descriptors) {
            Assert.assertEquals((String)descriptor.getAnnotation().annotationType().getName(), (String)AlwaysValid.class.getName(), (String)"Wrong annotation type.");
        }
        Set constraintViolations = validator.validate((Object)new Person("John", "Doe"), new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 1);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-multipleconstraints", id="a"), @SpecAssertion(section="constraintsdefinitionimplementation-multipleconstraints", id="b")})
    public void testRepeatableConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Set descriptors = validator.getConstraintsForClass(Movie.class).getConstraintsForProperty("title").getConstraintDescriptors();
        Assert.assertEquals((int)descriptors.size(), (int)2, (String)"There should be two constraints on the title property.");
        for (ConstraintDescriptor descriptor : descriptors) {
            Assert.assertEquals((String)descriptor.getAnnotation().annotationType().getName(), (String)Size.class.getName(), (String)"Wrong annotation type.");
        }
        Set constraintViolations = validator.validate((Object)new Movie("Title"), new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
        constraintViolations = validator.validate((Object)new Movie("A"), new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 1);
        constraintViolations = validator.validate((Object)new Movie("A movie title far too long that does not respect the constraint"), new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 1);
    }

    @Test
    @SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition-properties-groups", id="d")
    public void testDefaultGroupAssumedWhenNoGroupsSpecified() {
        Validator validator = TestUtil.getValidatorUnderTest();
        ConstraintDescriptor descriptor = (ConstraintDescriptor)validator.getConstraintsForClass(Person.class).getConstraintsForProperty("firstName").getConstraintDescriptors().iterator().next();
        Set groups = descriptor.getGroups();
        Assert.assertEquals((int)groups.size(), (int)1, (String)"The group set should only contain one entry.");
        Assert.assertEquals(groups.iterator().next(), Default.class, (String)"The Default group should be returned.");
    }
}

