/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.builtinconstraints;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Set;
import javax.validation.Validator;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class DecimalMinDecimalMaxConstraintsTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)DecimalMinDecimalMaxConstraintsTest.webArchiveBuilder().withTestClass(DecimalMinDecimalMaxConstraintsTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-decimalmin", id="a")})
    public void testDecimalMinConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        DecimalMinDummyEntity dummy = new DecimalMinDummyEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 4);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("bytePrimitive"), ConstraintViolationAssert.pathWith().property("intPrimitive"), ConstraintViolationAssert.pathWith().property("longPrimitive"), ConstraintViolationAssert.pathWith().property("shortPrimitive"));
        dummy.intPrimitive = 101;
        dummy.longPrimitive = 1001L;
        dummy.bytePrimitive = (byte)111;
        dummy.shortPrimitive = (short)142;
        dummy.intObject = Integer.valueOf("100");
        dummy.longObject = Long.valueOf("0");
        dummy.byteObject = Byte.parseByte("-1");
        dummy.shortObject = Short.parseShort("3");
        dummy.bigDecimal = BigDecimal.valueOf(100.9);
        dummy.bigInteger = BigInteger.valueOf(100L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 6);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("byteObject"), ConstraintViolationAssert.pathWith().property("intObject"), ConstraintViolationAssert.pathWith().property("longObject"), ConstraintViolationAssert.pathWith().property("shortObject"), ConstraintViolationAssert.pathWith().property("bigDecimal"), ConstraintViolationAssert.pathWith().property("bigInteger"));
        dummy.intObject = Integer.valueOf("101");
        dummy.longObject = Long.valueOf("12345");
        dummy.byteObject = Byte.parseByte("102");
        dummy.shortObject = Short.parseShort("111");
        dummy.bigDecimal = BigDecimal.valueOf(101.1);
        dummy.bigInteger = BigInteger.valueOf(101L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-decimalmax", id="a")})
    public void testDecimalMaxConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        DecimalMaxDummyEntity dummy = new DecimalMaxDummyEntity();
        dummy.intPrimitive = 102;
        dummy.longPrimitive = 1234L;
        dummy.bytePrimitive = (byte)102;
        dummy.shortPrimitive = (short)102;
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 4);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("bytePrimitive"), ConstraintViolationAssert.pathWith().property("intPrimitive"), ConstraintViolationAssert.pathWith().property("longPrimitive"), ConstraintViolationAssert.pathWith().property("shortPrimitive"));
        dummy.intPrimitive = 101;
        dummy.longPrimitive = 100L;
        dummy.bytePrimitive = (byte)99;
        dummy.shortPrimitive = (short)42;
        dummy.intObject = Integer.valueOf("102");
        dummy.longObject = Long.valueOf("12345");
        dummy.byteObject = Byte.parseByte("111");
        dummy.shortObject = Short.parseShort("1234");
        dummy.bigDecimal = BigDecimal.valueOf(102L);
        dummy.bigInteger = BigInteger.valueOf(102L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 6);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("byteObject"), ConstraintViolationAssert.pathWith().property("intObject"), ConstraintViolationAssert.pathWith().property("longObject"), ConstraintViolationAssert.pathWith().property("shortObject"), ConstraintViolationAssert.pathWith().property("bigDecimal"), ConstraintViolationAssert.pathWith().property("bigInteger"));
        dummy.intObject = Integer.valueOf("101");
        dummy.longObject = Long.valueOf("100");
        dummy.byteObject = Byte.parseByte("100");
        dummy.shortObject = Short.parseShort("101");
        dummy.bigDecimal = BigDecimal.valueOf(100.9);
        dummy.bigInteger = BigInteger.valueOf(100L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
    }

    private static class DecimalMinDummyEntity {
        @DecimalMin(value="101.000000000")
        private @DecimalMin(value="101.000000000") BigDecimal bigDecimal;
        @DecimalMin(value="1.01E+2")
        private @DecimalMin(value="1.01E+2") BigInteger bigInteger;
        @DecimalMin(value="101")
        private @DecimalMin(value="101") byte bytePrimitive;
        @DecimalMin(value="101")
        private @DecimalMin(value="101") short shortPrimitive;
        @DecimalMin(value="101")
        private @DecimalMin(value="101") int intPrimitive;
        @DecimalMin(value="101")
        private @DecimalMin(value="101") long longPrimitive;
        @DecimalMin(value="101")
        private @DecimalMin(value="101") Byte byteObject;
        @DecimalMin(value="101")
        private @DecimalMin(value="101") Short shortObject;
        @DecimalMin(value="101")
        private @DecimalMin(value="101") Integer intObject;
        @DecimalMin(value="101")
        private @DecimalMin(value="101") Long longObject;

        private DecimalMinDummyEntity() {
        }
    }

    private static class DecimalMaxDummyEntity {
        @DecimalMax(value="101.000000000")
        private @DecimalMax(value="101.000000000") BigDecimal bigDecimal;
        @DecimalMax(value="1.01E+2")
        private @DecimalMax(value="1.01E+2") BigInteger bigInteger;
        @DecimalMax(value="101")
        private @DecimalMax(value="101") byte bytePrimitive;
        @DecimalMax(value="101")
        private @DecimalMax(value="101") short shortPrimitive;
        @DecimalMax(value="101")
        private @DecimalMax(value="101") int intPrimitive;
        @DecimalMax(value="101")
        private @DecimalMax(value="101") long longPrimitive;
        @DecimalMax(value="101")
        private @DecimalMax(value="101") Byte byteObject;
        @DecimalMax(value="101")
        private @DecimalMax(value="101") Short shortObject;
        @DecimalMax(value="101")
        private @DecimalMax(value="101") Integer intObject;
        @DecimalMax(value="101")
        private @DecimalMax(value="101") Long longObject;

        private DecimalMaxDummyEntity() {
        }
    }
}

