/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.ide;

import eglx.java.JavaObjectException;
import eglx.lang.AnyException;
import eglx.lang.Resources;
import eglx.persistence.sql.SQLDataSource;
import eglx.persistence.sql.SQLJNDIDataSource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.eclipse.edt.javart.ide.IDEResourceLocator;
import org.eclipse.edt.javart.resources.egldd.Binding;
import org.eclipse.edt.javart.resources.egldd.RuntimeDeploymentDesc;
import org.eclipse.edt.javart.resources.egldd.SQLDatabaseBinding;
import org.eclipse.edt.runtime.java.eglx.lang.EDictionary;
import resources.edt.binding.BindingResourceProcessor;

public class IDEBindingResourceProcessor
extends BindingResourceProcessor {
    private URI defaultDD;
    private final String ideURL;

    public IDEBindingResourceProcessor(int idePort, IDEResourceLocator resourceLocator) {
        this.resourceLocator = resourceLocator;
        this.ideURL = "http://localhost:" + idePort + "/__testServer";
    }

    @Override
    protected Binding getBinding(String bindingURI, URI propertyFileURI, Resources.ResourceLocator resourceLocator) {
        QName resourceId = new QName(propertyFileURI.toASCIIString(), bindingURI);
        Binding binding = (Binding)bindings.get(resourceId);
        if (binding == null) {
            RuntimeDeploymentDesc dd = this.getDeploymentDesc(propertyFileURI, resourceLocator);
            binding = this.getBinding(bindingURI, dd);
            if (binding != null) {
                bindings.put(resourceId, binding);
            } else {
                String normalizedName = resourceLocator instanceof IDEResourceLocator ? ((IDEResourceLocator)resourceLocator).normalizePropertyFileName(propertyFileURI.toString()) : dd.getName();
                HashSet<String> seenDDs = new HashSet<String>();
                seenDDs.add(normalizedName);
                binding = this.getBinding(bindingURI, dd.getIncludedDescs(), resourceLocator, seenDDs);
            }
        }
        return binding;
    }

    @Override
    protected Binding getBinding(String name, List<String> includes, Resources.ResourceLocator resourceLocator, Set<String> seenDDs) throws AnyException {
        ArrayList<RuntimeDeploymentDesc> includedDDs = new ArrayList<RuntimeDeploymentDesc>();
        for (String ddName : includes) {
            try {
                URI uri = this.createFileURI(ddName);
                String normalizedName = resourceLocator instanceof IDEResourceLocator ? ((IDEResourceLocator)resourceLocator).normalizePropertyFileName(uri.toString()) : ddName;
                if (seenDDs.contains(normalizedName)) continue;
                seenDDs.add(normalizedName);
                QName resourceId = new QName(uri.toASCIIString(), name);
                Binding binding = (Binding)bindings.get(resourceId);
                if (binding != null) {
                    return binding;
                }
                RuntimeDeploymentDesc includedDD = this.getDeploymentDesc(uri, resourceLocator);
                binding = this.getBinding(name, includedDD);
                if (binding != null) {
                    bindings.put(resourceId, binding);
                    return binding;
                }
                includedDDs.add(includedDD);
            }
            catch (URISyntaxException e) {
                JavaObjectException jox = new JavaObjectException();
                jox.exceptionType = URI.class.getName();
                jox.initCause((Throwable)e);
                throw jox.fillInMessage("EGL0047E", new Object[]{ddName});
            }
        }
        for (RuntimeDeploymentDesc includedDD : includedDDs) {
            Binding binding = this.getBinding(name, includedDD.getIncludedDescs(), resourceLocator, seenDDs);
            if (binding == null) continue;
            return binding;
        }
        return null;
    }

    @Override
    protected Object getResource(Binding binding, URI dd) throws AnyException {
        if (binding instanceof SQLDatabaseBinding) {
            SQLDatabaseBinding sqlBinding = (SQLDatabaseBinding)binding;
            if (sqlBinding.isUseURI()) {
                String uri = sqlBinding.getUri();
                if (uri != null && uri.startsWith("workspace://")) {
                    SQLConnectionInfo info;
                    if (sqlBinding.isDeployAsJndi()) {
                        String jndiName = sqlBinding.getJndiName();
                        if (jndiName != null && (jndiName = jndiName.trim()).length() > 0) {
                            SQLConnectionInfo info2;
                            EDictionary props = null;
                            if (sqlBinding.isApplicationAuthentication() && (info2 = this.getParsedConnectionProfileSettings(uri.substring(12))) != null) {
                                props = new EDictionary();
                                if (info2.username != null && info2.username.length() > 0) {
                                    props.put("user", (Object)info2.username);
                                }
                                if (info2.password != null && info2.password.length() > 0) {
                                    props.put("password", (Object)info2.password);
                                }
                            }
                            return new SQLJNDIDataSource(jndiName, props);
                        }
                        System.err.println("WARN: jndiName parameter missing for resource binding " + sqlBinding.getName() + ". JNDI connection will NOT be used");
                    }
                    if ((info = this.getParsedConnectionProfileSettings(uri.substring(12))) != null) {
                        EDictionary props = new EDictionary();
                        if (info.username != null && info.username.length() > 0) {
                            props.put("user", (Object)info.username);
                        }
                        if (info.password != null && info.password.length() > 0) {
                            props.put("password", (Object)info.password);
                        }
                        if (info.driverClass != null && info.driverClass.length() > 0) {
                            try {
                                Class.forName(info.driverClass);
                            }
                            catch (Throwable throwable) {}
                        }
                        SQLDataSource ds = new SQLDataSource(info.url, (eglx.lang.EDictionary)props);
                        if (info.defaultSchema != null && info.defaultSchema.length() > 0) {
                            ds.setCurrentSchema(info.defaultSchema);
                        }
                        return ds;
                    }
                }
            } else if (sqlBinding.isDeployAsJndi()) {
                String jndiName = sqlBinding.getJndiName();
                if (jndiName != null && (jndiName = jndiName.trim()).length() > 0) {
                    EDictionary props = null;
                    if (sqlBinding.isApplicationAuthentication()) {
                        props = new EDictionary();
                        String user = sqlBinding.getSqlID();
                        String pass = sqlBinding.getSqlPassword();
                        if (user.length() > 0) {
                            props.put("user", (Object)user);
                        }
                        if (pass.length() > 0) {
                            props.put("password", (Object)pass);
                        }
                    }
                    return new SQLJNDIDataSource(jndiName, (eglx.lang.EDictionary)props);
                }
                System.err.println("WARN: jndiName parameter missing for resource binding " + sqlBinding.getName() + ". JNDI connection will NOT be used");
            }
        }
        return super.getResource(binding, dd);
    }

    @Override
    protected URI getDefaultDDURI() {
        if (this.defaultDD == null) {
            AnyException ae = new AnyException();
            throw ae.fillInMessage("EGL0049E", new Object[0]);
        }
        return this.defaultDD;
    }

    public void setDefaultDD(String dd) throws AnyException {
        if (dd == null || (dd = dd.trim()).length() == 0) {
            this.defaultDD = null;
        } else {
            try {
                try {
                    dd = URLEncoder.encode(dd, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                this.defaultDD = this.createFileURI(dd);
            }
            catch (URISyntaxException e) {
                JavaObjectException jox = new JavaObjectException();
                jox.exceptionType = URI.class.getName();
                jox.initCause((Throwable)e);
                throw jox.fillInMessage("EGL0047E", new Object[]{this.defaultDD});
            }
        }
    }

    public IDEResourceLocator getResourceLocator() {
        return (IDEResourceLocator)this.resourceLocator;
    }

    public SQLConnectionInfo getParsedConnectionProfileSettings(String profileName) {
        String[] tokens;
        String profileInfo = this.getConnectionProfileSettings(profileName);
        if (profileInfo != null && profileInfo.length() > 0 && (tokens = profileInfo.split(";")).length > 0) {
            String url = tokens[0].trim();
            String user = null;
            String pass = null;
            String schema = null;
            String className = null;
            if (tokens.length > 1) {
                user = tokens[1].trim();
            }
            if (tokens.length > 2) {
                pass = tokens[2].trim();
            }
            if (tokens.length > 3) {
                schema = tokens[3].trim();
            }
            if (tokens.length > 4) {
                className = tokens[4].trim();
            }
            try {
                url = URLDecoder.decode(url, "UTF-8");
                if (user != null) {
                    user = URLDecoder.decode(user, "UTF-8");
                }
                if (pass != null) {
                    pass = URLDecoder.decode(pass, "UTF-8");
                }
                if (schema != null) {
                    schema = URLDecoder.decode(schema, "UTF-8");
                }
                if (className != null) {
                    className = URLDecoder.decode(className, "UTF-8");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            SQLConnectionInfo info = new SQLConnectionInfo();
            info.url = url;
            info.username = user;
            info.password = pass;
            info.defaultSchema = schema;
            info.driverClass = className;
            return info;
        }
        return null;
    }

    private String getConnectionProfileSettings(String profileName) {
        String connectionURL;
        block24: {
            connectionURL = null;
            InputStream is = null;
            try {
                try {
                    HttpURLConnection conn = (HttpURLConnection)new URL(this.ideURL).openConnection();
                    conn.setDoOutput(true);
                    conn.setRequestProperty("Accept-Charset", "UTF-8");
                    conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
                    OutputStream output = null;
                    try {
                        output = conn.getOutputStream();
                        output.write(("connectionProfile=" + profileName).getBytes("UTF-8"));
                    }
                    catch (Throwable throwable) {
                        if (output != null) {
                            try {
                                output.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (conn.getResponseCode() == 200) {
                        String line;
                        is = conn.getInputStream();
                        BufferedReader br = new BufferedReader(new InputStreamReader(is));
                        StringBuilder buf = new StringBuilder(50);
                        while ((line = br.readLine()) != null) {
                            buf.append(line);
                        }
                        connectionURL = buf.toString();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return connectionURL;
    }

    public static class SQLConnectionInfo {
        public String username;
        public String password;
        public String driverClass;
        public String url;
        public String defaultSchema;
    }
}

