/*******************************************************************************
 * Copyright © 2008, 2013 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
package org.eclipse.edt.ide.ui.internal.project.features;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.edt.ide.ui.EDTUIPreferenceConstants;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.wizards.EGLProjectEGLDDGenerationOperation;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

/**
 * The deployment descriptor project feature. This will generate and add a default deployment descriptor
 * to the project

 * 11-15-2007:	Initial version
 *
 */
public class AutoGenerateDeploymentDescriptorFeature implements IEGLProjectFeature {

	/**
	 * Class constructor
	 */
	public AutoGenerateDeploymentDescriptorFeature() {
		//	must have a  zero arg constructor as this is a plugin contribution
	}

	/* (non-Javadoc)
	 * @see com.ibm.etools.egl.internal.ui.project.features.IEGLProjectFeature#getFeatureMask()
	 */
	public int getFeatureMask() {
		return EDTUIPreferenceConstants.EGLFEATURE_EGLDD;
	}

	/* (non-Javadoc)
	 * @see com.ibm.etools.egl.internal.ui.project.features.IEGLProjectFeature#getFeatureOperation(org.eclipse.core.resources.IProject, org.eclipse.core.runtime.jobs.ISchedulingRule, boolean)
	 */
	public WorkspaceModifyOperation getFeatureOperation(IProject project, ISchedulingRule rule, boolean isWebProject, boolean isCobol) {
		return new EGLProjectEGLDDGenerationOperation(project, rule, isWebProject);
	}

	/* (non-Javadoc)
	 * @see com.ibm.etools.egl.internal.ui.project.features.IEGLProjectFeature#getLabel()
	 */
	public String getLabel() {
		return UINlsStrings.EGLProjectFeatureGroup_DD;
	}

	/* (non-Javadoc)
	 * @see com.ibm.etools.egl.internal.ui.project.features.IEGLProjectFeature#isValidForWebProject()
	 */
	public boolean isValidForWebProject() {
		return true;
	}

	/* (non-Javadoc)
	 * @see com.ibm.etools.egl.internal.ui.project.features.IEGLProjectFeature#getDefaultPreferenceSetting()
	 */
	public boolean getDefaultPreferenceSetting() {
		return true;
	}

	/* (non-Javadoc)
	 * @see com.ibm.etools.egl.internal.project.features.IEGLProjectFeature#executeOperation(org.eclipse.core.resources.IProject, boolean)
	 */
	public void executeOperation(IProject project, boolean isWebProject) throws CoreException, InvocationTargetException {
		EGLProjectEGLDDGenerationOperation.executeOperation(project);
	}

	/* (non-Javadoc)
	 * @see com.ibm.etools.egl.internal.project.features.IEGLProjectFeature#isValidForCobolProject()
	 */
	public boolean isValidForCobolProject() {
		return true;
	}

}
