/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.eunit.ui.testresult;

import com.ibm.icu.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.core.runtime.Platform;
import org.eclipse.edt.ide.eunit.internal.chart.ChartPreview;
import org.eclipse.edt.ide.eunit.internal.chart.Pie;
import org.eclipse.edt.ide.eunit.ui.testresult.ResultSummaryBlock;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class TestResultPkgNodeDetailsPage
implements IDetailsPage {
    protected IManagedForm mform;
    protected int nColumnSpan = 3;
    ResultSummaryBlock.ResultStatisticCnts statisticCnt;
    private static final String BIRT_PLUGIN_ID = "org.eclipse.birt";
    protected List<Color> colors = new ArrayList<Color>();
    private Color red;
    private Color green;
    private Color purple;
    private Color orange;

    public TestResultPkgNodeDetailsPage(ResultSummaryBlock.ResultStatisticCnts statistic) {
        this.statisticCnt = statistic;
    }

    public void commit(boolean arg0) {
    }

    public void dispose() {
        if (this.colors != null && !this.colors.isEmpty()) {
            for (Color color : this.colors) {
                color.dispose();
            }
        }
        this.colors.clear();
        this.colors = null;
    }

    public void initialize(IManagedForm form) {
        this.mform = form;
    }

    protected Color getGreen() {
        if (this.green == null) {
            this.green = new Color((Device)Display.getCurrent(), new RGB(0, 128, 0));
            this.colors.add(this.green);
        }
        return this.green;
    }

    protected Color getRed() {
        if (this.red == null) {
            this.red = new Color((Device)Display.getCurrent(), new RGB(255, 0, 0));
            this.colors.add(this.red);
        }
        return this.red;
    }

    protected Color getPurple() {
        if (this.purple == null) {
            this.purple = new Color((Device)Display.getCurrent(), new RGB(184, 0, 73));
            this.colors.add(this.purple);
        }
        return this.purple;
    }

    protected Color getOrange() {
        if (this.orange == null) {
            this.orange = new Color((Device)Display.getCurrent(), new RGB(255, 127, 0));
            this.colors.add(this.orange);
        }
        return this.orange;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isStale() {
        return false;
    }

    public void refresh() {
    }

    public void setFocus() {
    }

    public boolean setFormInput(Object arg0) {
        return false;
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        selection.toString();
    }

    public void createContents(Composite parent) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 5;
        layout.leftMargin = 5;
        layout.rightMargin = 5;
        layout.bottomMargin = 2;
        parent.setLayout((Layout)layout);
        FormToolkit toolkit = this.mform.getToolkit();
        this.createTopNonExpandableSection(parent, toolkit);
    }

    protected void createTopNonExpandableSection(Composite parent, FormToolkit toolkit) {
        Composite client = this.createDetailSection(parent, toolkit, 640, this.nColumnSpan);
        this.createControlsInTopSection(toolkit, client);
    }

    protected Composite createDetailSection(Composite parent, FormToolkit toolkit, int sectionStyle, int columnSpan) {
        return this.createSection(parent, toolkit, "", "", sectionStyle, columnSpan);
    }

    private void createSummaryLine(FormToolkit toolkit, Composite parent, int cnt, String resultText, Color color, boolean createIfZero) {
        if (createIfZero || cnt > 0) {
            DecimalFormat df = new DecimalFormat("##.##%");
            double rate = (double)cnt / (double)this.statisticCnt.getExpectedCnt();
            String failedSummary = String.valueOf(cnt) + " out of " + this.statisticCnt.getExpectedCnt() + ", [" + df.format(rate) + "] " + resultText;
            this.createColorBoldReadOnlyNoBoraderText(toolkit, parent, this.nColumnSpan, failedSummary, color);
        }
    }

    protected void createControlsInTopSection(FormToolkit toolkit, Composite parent) {
        String errMsg;
        this.createSpacer(toolkit, parent, this.nColumnSpan);
        this.createSummaryLine(toolkit, parent, this.statisticCnt.getPassedCnt(), " PASSED.", this.getGreen(), true);
        this.createSummaryLine(toolkit, parent, this.statisticCnt.getFailedCnt() + this.statisticCnt.getBadCnt(), " FAILED.", this.getRed(), false);
        this.createSummaryLine(toolkit, parent, this.statisticCnt.getExCnt(), " THREW EXCEPTION.", this.getPurple(), false);
        this.createSummaryLine(toolkit, parent, this.statisticCnt.getNotRunCnt(), " SKIPPED.", this.getOrange(), false);
        if (this.statisticCnt.getTestCnt() != this.statisticCnt.getExpectedCnt()) {
            errMsg = "ERROR: Expected count [" + this.statisticCnt.getExpectedCnt() + "] is different from the actual test ran [" + this.statisticCnt.getTestCnt() + "]";
            this.createErrorReadOnlyNoBoarderText(toolkit, parent, this.nColumnSpan, errMsg);
        }
        if (this.isBIRTPluginInstalled()) {
            this.createPieChart(parent);
        } else {
            errMsg = "NOTE: You need birt chart engine to view pie chart, please install BIRT feature (version 2.6.2 and up)";
            this.createErrorReadOnlyNoBoarderText(toolkit, parent, this.nColumnSpan, errMsg);
        }
        this.createReadOnlyNoBorderText(toolkit, parent, this.nColumnSpan, "");
        this.createReadOnlyNoBorderText(toolkit, parent, this.nColumnSpan, "testCnt: " + this.statisticCnt.getTestCnt());
        this.createReadOnlyNoBorderText(toolkit, parent, this.nColumnSpan, "expCnt: " + this.statisticCnt.getExpectedCnt());
        this.createReadOnlyNoBorderText(toolkit, parent, this.nColumnSpan, "passedCnt: " + this.statisticCnt.getPassedCnt());
        this.createReadOnlyNoBorderText(toolkit, parent, this.nColumnSpan, "failedCnt: " + this.statisticCnt.getFailedCnt());
        this.createReadOnlyNoBorderText(toolkit, parent, this.nColumnSpan, "exCnt: " + this.statisticCnt.getExCnt());
        this.createReadOnlyNoBorderText(toolkit, parent, this.nColumnSpan, "badCnt: " + this.statisticCnt.getBadCnt());
        this.createReadOnlyNoBorderText(toolkit, parent, this.nColumnSpan, "notRunCnt: " + this.statisticCnt.getNotRunCnt());
    }

    private void createPieChart(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(1808));
        GridData gridData = new GridData(1296);
        gridData.horizontalSpan = this.nColumnSpan;
        parent.setLayoutData((Object)gridData);
        Canvas paintCanvas = new Canvas(parent, 2048);
        GridData gridData1 = new GridData(1808);
        gridData1.horizontalSpan = this.nColumnSpan;
        gridData1.verticalSpan = 100;
        paintCanvas.setLayoutData((Object)gridData1);
        paintCanvas.setBackground(Display.getDefault().getSystemColor(1));
        ChartPreview preview = new ChartPreview();
        paintCanvas.addPaintListener((PaintListener)preview);
        paintCanvas.addControlListener((ControlListener)preview);
        preview.setPreview(paintCanvas);
        TextDataSet categoryValues = TextDataSetImpl.create((Object)new String[]{"Passed", "Failed", "Exception", "Skipped"});
        NumberDataSet seriesOneValues = NumberDataSetImpl.create((Object)new double[]{this.statisticCnt.getPassedCnt(), this.statisticCnt.getFailedCnt() + this.statisticCnt.getBadCnt(), this.statisticCnt.getExCnt(), this.statisticCnt.getNotRunCnt()});
        preview.renderModel(Pie.createPie(categoryValues, seriesOneValues).copyInstance());
    }

    protected Label createSpacer(FormToolkit toolkit, Composite parent, int span) {
        return this.createOneLabelPerLine(toolkit, parent, span, "");
    }

    private Label createOneLabelPerLine(FormToolkit toolkit, Composite parent, int span, String labelText) {
        Label spacer = toolkit.createLabel(parent, labelText);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        spacer.setLayoutData((Object)gd);
        return spacer;
    }

    protected Text createReadOnlyNoBorderText(FormToolkit toolkit, Composite parent, int span, String labelText) {
        boolean toggleBorder;
        boolean bl = toggleBorder = toolkit.getBorderStyle() == 2048;
        if (toggleBorder) {
            toolkit.setBorderStyle(0);
        }
        Text spacer = toolkit.createText(parent, labelText, 10);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        spacer.setLayoutData((Object)gd);
        return spacer;
    }

    protected Text createErrorReadOnlyNoBoarderText(FormToolkit toolkit, Composite parent, int span, String labelText) {
        return this.createColorBoldReadOnlyNoBoraderText(toolkit, parent, span, labelText, this.getRed());
    }

    protected Text createColorBoldReadOnlyNoBoraderText(FormToolkit toolkit, Composite parent, int span, String labelText, Color color) {
        Text textControl = this.createReadOnlyNoBorderText(toolkit, parent, span, labelText);
        textControl.setForeground(color);
        textControl.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        return textControl;
    }

    protected Composite createSection(Composite parent, FormToolkit toolkit, String title, String desc, int SectionStyle, int numColumns) {
        Section section = toolkit.createSection(parent, SectionStyle);
        section.marginWidth = 10;
        section.setText(title);
        section.setDescription(desc);
        TableWrapData td = new TableWrapData(128, 16);
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite client = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.numColumns = numColumns;
        client.setLayout((Layout)layout);
        section.setClient((Control)client);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                TestResultPkgNodeDetailsPage.this.mform.getForm().reflow(false);
            }
        });
        return client;
    }

    protected boolean isBIRTPluginInstalled() {
        State state = Platform.getPlatformAdmin().getState(false);
        BundleDescription bundle = state.getBundle(BIRT_PLUGIN_ID, null);
        boolean versionCheck = false;
        if (bundle != null) {
            int majorV = bundle.getVersion().getMajor();
            int minorV = bundle.getVersion().getMinor();
            int microV = bundle.getVersion().getMicro();
            if (majorV > 2) {
                versionCheck = true;
            } else if (majorV == 2) {
                if (minorV > 6) {
                    versionCheck = true;
                } else if (minorV == 6 && microV >= 1) {
                    versionCheck = true;
                }
            }
        }
        return bundle != null && bundle.getResolvedRequires().length == bundle.getRequiredBundles().length && versionCheck;
    }
}

