/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.eunit.internal.actions;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.edt.compiler.ICompiler;
import org.eclipse.edt.gen.eunit.EGL2JavascriptDriver;
import org.eclipse.edt.gen.eunit.IEUnitGenerationNotifier;
import org.eclipse.edt.ide.core.IIDECompiler;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.eunit.internal.actions.GenTestDriverAction;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class GenTestDriverActionJavascript
extends GenTestDriverAction {
    protected static final String DRIVERPROJSUFFIX_JAVASCRIPT = ".eunit.javascript";
    protected static final String token_javascript = "javascript";

    public GenTestDriverActionJavascript() {
        this.EUNITRUNTIME_FILE_BYLANG = new String[]{"CreateResultFile.egl", "TestResultService.egl"};
    }

    @Override
    protected List<WorkspaceModifyOperation> getGenTestDriverOperatoins(IWorkspaceRoot wsRoot, String baseProjName, IProject baseProj, IEGLProject baseEGLProj) {
        String driverProjName = this.getDriverProjName(baseProjName);
        IProject driverProj = wsRoot.getProject(driverProjName);
        IEGLProject driverEGLProject = EGLCore.create((IProject)driverProj);
        ArrayList<WorkspaceModifyOperation> ops = new ArrayList<WorkspaceModifyOperation>();
        WorkspaceModifyOperation op1 = this.getCreateEGLProjectOperation(wsRoot, driverProjName, baseProjName);
        ops.add(op1);
        WorkspaceModifyOperation op2 = this.getSetGeneratorIDOperation(driverProj, new String[]{"org.eclipse.edt.ide.gen.JavaScriptGenProvider", "org.eclipse.edt.ide.gen.JavaScriptDevGenProvider"});
        ops.add(op2);
        WorkspaceModifyOperation op3 = this.getSetEGLBuildPathOperation(driverEGLProject, driverProjName, baseProjName);
        ops.add(op3);
        WorkspaceModifyOperation op5 = this.getCopyJSECKRuntimeFilesOperation(driverProj);
        ops.add(op5);
        WorkspaceModifyOperation op6 = this.getCreateRununitPropertyOperation(wsRoot, driverProj);
        ops.add(op6);
        WorkspaceModifyOperation op7 = this.getGenDriverOperation(wsRoot, baseProj, baseEGLProj, driverProj, driverEGLProject);
        ops.add(op7);
        WorkspaceModifyOperation op8 = this.getRefreshWSOperation(baseProj, driverProj);
        ops.add(op8);
        return ops;
    }

    protected String getDriverProjName(String baseProjName) {
        String driverProjName = String.valueOf(baseProjName) + DRIVERPROJSUFFIX_JAVASCRIPT;
        return driverProjName;
    }

    protected WorkspaceModifyOperation getCopyJSECKRuntimeFilesOperation(IProject driverProj) {
        return this.getCopyECKRuntimeFilesOperation(driverProj, token_javascript);
    }

    @Override
    protected void invokeDriverGenerator(String[] args, IIDECompiler compiler, IEUnitGenerationNotifier eckGenerationNotifier) {
        EGL2JavascriptDriver.start((String[])args, (ICompiler)compiler, (IEUnitGenerationNotifier)eckGenerationNotifier);
    }

    @Override
    protected WorkspaceModifyOperation getCreateRununitPropertyOperation(IWorkspaceRoot wsRoot, final IProject driverProject) {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                monitor.subTask("Creating rununit property EGLTestResultRoot");
                String resultRootFolder = driverProject.getFolder("ResultRoot").getLocation().toOSString();
                String jsonResultRootFolder = GenTestDriverActionJavascript.convertJavaToJson(resultRootFolder);
                IFolder webContentFolder = driverProject.getFolder("WebContent");
                if (!webContentFolder.exists()) {
                    webContentFolder.create(true, true, monitor);
                }
                IFile propertyFile = webContentFolder.getFile("rununit.html");
                String propertyOSPath = propertyFile.getLocation().toOSString();
                try {
                    PrintWriter outWriter = new PrintWriter(propertyOSPath);
                    outWriter.println("<script type=\"text/javascript\">");
                    outWriter.println("try{egl.eze$$runtimeProperties['rununit'] = ");
                    outWriter.print("{\"");
                    outWriter.print("EGLTestResultRoot");
                    outWriter.print("\" : \"");
                    outWriter.print(jsonResultRootFolder);
                    outWriter.println("\"};}catch(e){ }");
                    outWriter.println("</script>");
                    outWriter.flush();
                    outWriter.close();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                monitor.worked(1);
            }
        };
        return op;
    }

    private static String convertJavaToJson(String value) {
        StringBuilder inBuf = new StringBuilder(value);
        StringBuilder outBuf = new StringBuilder();
        int idx = 0;
        while (idx < inBuf.length()) {
            char currentChar = inBuf.charAt(idx);
            switch (currentChar) {
                case '\\': {
                    outBuf.append("\\\\");
                    break;
                }
                case '\"': {
                    outBuf.append("\\\"");
                    break;
                }
                case '/': {
                    outBuf.append("\\/");
                    break;
                }
                case '\b': {
                    outBuf.append("\\b");
                    break;
                }
                case '\f': {
                    outBuf.append("\\f");
                    break;
                }
                case '\n': {
                    outBuf.append("\\n");
                    break;
                }
                case '\r': {
                    outBuf.append("\\r");
                    break;
                }
                case '\t': {
                    outBuf.append("\\t");
                    break;
                }
                default: {
                    if (Character.isISOControl(currentChar)) {
                        String controlEsc = "0000";
                        controlEsc = String.valueOf(controlEsc) + Integer.toHexString(currentChar);
                        outBuf.append("\\u");
                        outBuf.append(controlEsc.substring(controlEsc.length() - 4));
                        break;
                    }
                    outBuf.append(currentChar);
                }
            }
            ++idx;
        }
        return outBuf.toString();
    }
}

