/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.utils;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ResourceAndTLFMap {
    private IResource resource;
    private IPath[] irPaths = new Path[0];

    public ResourceAndTLFMap(IResource iResource, IPath path) {
        this.resource = iResource;
        this.addPath(path);
    }

    public IResource getResource() {
        return this.resource;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    public IPath[] getPaths() {
        return this.irPaths;
    }

    public void setPaths(IPath[] paths) {
        this.irPaths = paths;
    }

    public void addPath(IPath path) {
        Path[] temp = new Path[this.irPaths.length + 1];
        System.arraycopy(this.irPaths, 0, temp, 0, this.irPaths.length);
        temp[temp.length - 1] = path;
        this.irPaths = temp;
    }

    public boolean isSamePackage(IResource resource2Compare) {
        if (this.resource.getFullPath().segmentCount() < 2 || resource2Compare.getFullPath().segmentCount() < 2) {
            return false;
        }
        IPath temp = this.resource.getFullPath().removeFirstSegments(2).removeLastSegments(1);
        temp = new Path(temp.toString().toLowerCase());
        IPath toCompare = resource2Compare.getFullPath().removeFirstSegments(2).removeLastSegments(1);
        return temp.equals((Object)(toCompare = new Path(toCompare.toString().toLowerCase())));
    }

    public boolean includedPath(IPath path) {
        if (path == null) {
            return false;
        }
        IPath[] iPathArray = this.irPaths;
        int n = this.irPaths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath p = iPathArray[n2];
            if (p.equals((Object)path)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

