/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.search.matching;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.ide.core.internal.model.index.IEntryResult;
import org.eclipse.edt.ide.core.internal.model.index.impl.IndexInput;
import org.eclipse.edt.ide.core.internal.search.IIndexSearchRequestor;
import org.eclipse.edt.ide.core.internal.search.matching.MatchLocator2;
import org.eclipse.edt.ide.core.internal.search.matching.OrNameCombiner;
import org.eclipse.edt.ide.core.internal.search.matching.OrPathCombiner;
import org.eclipse.edt.ide.core.internal.search.matching.SearchPattern;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IFunction;
import org.eclipse.edt.ide.core.model.IMember;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.mof.egl.FunctionPart;

public class OrPattern
extends SearchPattern {
    public SearchPattern leftPattern;
    public SearchPattern rightPattern;

    public OrPattern(SearchPattern leftPattern, SearchPattern rightPattern) {
        super(-1, false);
        this.leftPattern = leftPattern;
        this.rightPattern = rightPattern;
        this.matchMode = Math.min(leftPattern.matchMode, rightPattern.matchMode);
        this.isCaseSensitive = leftPattern.isCaseSensitive || rightPattern.isCaseSensitive;
        this.needsResolve = leftPattern.needsResolve || rightPattern.needsResolve;
    }

    @Override
    protected void decodeIndexEntry(IEntryResult entry) {
    }

    @Override
    public void feedIndexRequestor(IIndexSearchRequestor requestor, int detailLevel, int[] references, IndexInput input, IEGLSearchScope scope) throws IOException {
    }

    @Override
    public void findIndexMatches(IndexInput input, IIndexSearchRequestor requestor, int detailLevel, IProgressMonitor progressMonitor, IEGLSearchScope scope) throws IOException {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        IIndexSearchRequestor orCombiner = detailLevel == 1 ? new OrNameCombiner(requestor) : new OrPathCombiner(requestor);
        this.leftPattern.findIndexMatches(input, orCombiner, detailLevel, progressMonitor, scope);
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.rightPattern.findIndexMatches(input, orCombiner, detailLevel, progressMonitor, scope);
    }

    @Override
    public char[] indexEntryPrefix() {
        return null;
    }

    @Override
    protected int matchContainer() {
        return this.leftPattern.matchContainer() | this.rightPattern.matchContainer();
    }

    @Override
    protected boolean matchIndexEntry() {
        return this.leftPattern.matchIndexEntry() || this.rightPattern.matchIndexEntry();
    }

    @Override
    protected void matchReportReference(Node reference, IEGLElement element, int accuracy, MatchLocator2 locator) throws CoreException {
        int leftLevel = this.leftPattern.matchLevel(reference, true);
        if (leftLevel == 2 || leftLevel == 3) {
            this.leftPattern.matchReportReference(reference, element, accuracy, locator);
        } else {
            this.rightPattern.matchReportReference(reference, element, accuracy, locator);
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.leftPattern.toString()) + "\n| " + this.rightPattern.toString();
    }

    @Override
    public int matchLevel(Node node, boolean resolve) {
        switch (this.leftPattern.matchLevel(node, resolve)) {
            case 0: {
                return this.rightPattern.matchLevel(node, resolve);
            }
            case 1: {
                return 1;
            }
            case 3: {
                int rightLevel = this.rightPattern.matchLevel(node, resolve);
                if (rightLevel != 0) {
                    return rightLevel;
                }
                return 3;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public int matchLevel(IMember member, boolean resolve) {
        switch (this.leftPattern.matchLevel(member, resolve)) {
            case 0: {
                return this.rightPattern.matchLevel(member, resolve);
            }
            case 1: {
                return 1;
            }
            case 3: {
                int rightLevel = this.rightPattern.matchLevel(member, resolve);
                if (rightLevel != 0) {
                    return rightLevel;
                }
                return 3;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public int matchesPartType(Name node, org.eclipse.edt.mof.egl.Part partBinding, boolean forceQualification) {
        int leftlevel = this.leftPattern.matchesPartType(node, partBinding, forceQualification);
        int rightlevel = this.rightPattern.matchesPartType(node, partBinding, forceQualification);
        return this.compareLevels(leftlevel, rightlevel);
    }

    @Override
    public int matchesFunctionPartType(Name node, FunctionPart partBinding) {
        int leftlevel = this.leftPattern.matchesFunctionPartType(node, partBinding);
        int rightlevel = this.rightPattern.matchesFunctionPartType(node, partBinding);
        return this.compareLevels(leftlevel, rightlevel);
    }

    @Override
    public int matchesFunctionPartType(IFunction function) {
        int leftlevel = this.leftPattern.matchesFunctionPartType(function);
        int rightlevel = this.rightPattern.matchesFunctionPartType(function);
        return this.compareLevels(leftlevel, rightlevel);
    }

    @Override
    public int matchesPart(Part node) {
        int leftlevel = this.leftPattern.matchesPart(node);
        int rightlevel = this.rightPattern.matchesPart(node);
        return this.compareLevels(leftlevel, rightlevel);
    }

    @Override
    public int matchesPart(IPart part) {
        int leftlevel = this.leftPattern.matchesPart(part);
        int rightlevel = this.rightPattern.matchesPart(part);
        return this.compareLevels(leftlevel, rightlevel);
    }

    protected int compareLevels(int leftlevel, int rightlevel) {
        if (leftlevel == 2 || rightlevel == 2) {
            return 2;
        }
        if (leftlevel == 3 || rightlevel == 3) {
            return 3;
        }
        return 0;
    }

    @Override
    public int getPatternType() {
        return this.leftPattern.getPatternType() | this.rightPattern.getPatternType();
    }
}

