/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.indexing;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.internal.model.index.IIndex;
import org.eclipse.edt.ide.core.internal.model.indexing.EGLReadWriteMonitor;
import org.eclipse.edt.ide.core.internal.model.indexing.IndexManager;
import org.eclipse.edt.ide.core.internal.model.indexing.IndexRequest;
import org.eclipse.edt.ide.core.internal.model.search.processing.JobManager;

class AddFolderToIndex
extends IndexRequest {
    IPath folderPath;
    IProject project;
    char[][] exclusionPattern;

    public AddFolderToIndex(IPath folderPath, IProject project, char[][] exclusionPattern, IndexManager manager) {
        super(project.getFullPath(), manager);
        this.folderPath = folderPath;
        this.project = project;
        this.exclusionPattern = exclusionPattern;
    }

    @Override
    public boolean execute(IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        if (!this.project.isAccessible()) {
            return true;
        }
        IResource folder = this.project.getParent().findMember(this.folderPath);
        if (folder == null || folder.getType() == 1) {
            return true;
        }
        IIndex index = this.manager.getIndex(this.indexPath, true, true);
        if (index == null) {
            return true;
        }
        EGLReadWriteMonitor monitor = this.manager.getMonitorFor(index);
        if (monitor == null) {
            return true;
        }
        try {
            try {
                monitor.enterRead();
                final IPath container = this.indexPath;
                final IndexManager indexManager = this.manager;
                final char[][] pattern = this.exclusionPattern;
                folder.accept(new IResourceProxyVisitor(){

                    public boolean visit(IResourceProxy proxy) throws CoreException {
                        switch (proxy.getType()) {
                            case 1: {
                                if (Util.isEGLFileName(proxy.getName())) {
                                    IResource resource = proxy.requestResource();
                                    if (pattern == null || !Util.isExcluded(resource, pattern)) {
                                        indexManager.addSource((IFile)resource, container);
                                    }
                                }
                                return false;
                            }
                            case 2: {
                                if (pattern == null || !Util.isExcluded(proxy.requestResource(), pattern)) break;
                                return false;
                            }
                        }
                        return true;
                    }
                }, 0);
            }
            catch (CoreException e) {
                if (JobManager.VERBOSE) {
                    JobManager.verbose("-> failed to add " + this.folderPath + " to index because of the following exception:");
                    e.printStackTrace();
                }
                monitor.exitRead();
                return false;
            }
        }
        finally {
            monitor.exitRead();
        }
        return true;
    }

    public String toString() {
        return "adding " + this.folderPath + " to index " + this.indexPath;
    }
}

