/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.index.impl;

import java.io.File;
import java.io.IOException;
import org.eclipse.edt.ide.core.internal.model.index.impl.PropertyDocument;
import org.eclipse.edt.ide.core.internal.model.util.Util;
import org.eclipse.edt.ide.core.model.EGLCore;

public class FileDocument
extends PropertyDocument {
    File file;

    public FileDocument(File file) {
        this.file = file;
    }

    @Override
    public byte[] getByteContent() throws IOException {
        return Util.getFileByteContent(this.file);
    }

    @Override
    public char[] getCharContent() throws IOException {
        return Util.getFileCharContent(this.file, null);
    }

    @Override
    public String getEncoding() {
        return EGLCore.getOption(EGLCore.CORE_ENCODING);
    }

    @Override
    public String getName() {
        return this.file.getAbsolutePath().replace(File.separatorChar, '/');
    }

    @Override
    public String getStringContent() throws IOException {
        return new String(this.getCharContent());
    }

    @Override
    public String getType() {
        int lastDot = this.file.getPath().lastIndexOf(46);
        if (lastDot == -1) {
            return "";
        }
        return this.file.getPath().substring(lastDot + 1);
    }
}

