/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.util.HashSet;
import org.eclipse.edt.ide.core.internal.model.EGLElementInfo;
import org.eclipse.edt.ide.core.internal.model.EGLModelManager;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.ide.core.internal.model.Openable;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElementDelta;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.model.IWorkingCopy;

public class ModelUpdater {
    HashSet projectsToUpdate = new HashSet();

    protected void addToParentInfo(Openable child) {
        Openable parent = (Openable)child.getParent();
        if (parent != null && parent.isOpen()) {
            try {
                EGLElementInfo info = (EGLElementInfo)parent.getElementInfo();
                info.addChild(child);
            }
            catch (EGLModelException eGLModelException) {}
        }
    }

    protected static void close(Openable element) {
        try {
            element.close();
        }
        catch (EGLModelException eGLModelException) {}
    }

    protected void elementAdded(Openable element) {
        int elementType = element.getElementType();
        if (elementType == 2) {
            this.addToParentInfo(element);
            this.projectsToUpdate.add(element);
        } else {
            this.addToParentInfo(element);
            ModelUpdater.close(element);
        }
        switch (elementType) {
            case 3: {
                this.projectsToUpdate.add(element.getEGLProject());
                break;
            }
            case 4: {
                EGLProject project = (EGLProject)element.getEGLProject();
                try {
                    project.getEGLProjectElementInfo().setNameLookup(null);
                    break;
                }
                catch (EGLModelException eGLModelException) {}
            }
        }
    }

    protected void elementChanged(Openable element) {
        ModelUpdater.close(element);
    }

    protected void elementRemoved(Openable element) {
        if (element.isOpen()) {
            ModelUpdater.close(element);
        }
        this.removeFromParentInfo(element);
        int elementType = element.getElementType();
        switch (elementType) {
            case 1: {
                EGLModelManager.getEGLModelManager().getIndexManager().reset();
                break;
            }
            case 2: {
                EGLModelManager.getEGLModelManager().removePerProjectInfo((EGLProject)element);
                break;
            }
            case 3: {
                this.projectsToUpdate.add(element.getEGLProject());
                break;
            }
            case 4: {
                EGLProject project = (EGLProject)element.getEGLProject();
                try {
                    project.getEGLProjectElementInfo().setNameLookup(null);
                    break;
                }
                catch (EGLModelException eGLModelException) {}
            }
        }
    }

    public void processEGLDelta(IEGLElementDelta delta) {
        try {
            this.traverseDelta(delta, null, null);
            for (EGLProject project : this.projectsToUpdate) {
                project.updatePackageFragmentRoots();
            }
        }
        finally {
            this.projectsToUpdate = new HashSet();
        }
    }

    protected void removeFromParentInfo(Openable child) {
        Openable parent = (Openable)child.getParent();
        if (parent != null && parent.isOpen()) {
            try {
                EGLElementInfo info = (EGLElementInfo)parent.getElementInfo();
                info.removeChild(child);
            }
            catch (EGLModelException eGLModelException) {}
        }
    }

    protected void traverseDelta(IEGLElementDelta delta, IPackageFragmentRoot root, IEGLProject project) {
        boolean processChildren = true;
        Openable element = (Openable)delta.getElement();
        switch (element.getElementType()) {
            case 2: {
                project = (IEGLProject)((Object)element);
                break;
            }
            case 3: {
                root = (IPackageFragmentRoot)((Object)element);
                break;
            }
            case 6: {
                if (((IWorkingCopy)((Object)element)).isWorkingCopy()) {
                    return;
                }
                processChildren = false;
            }
        }
        switch (delta.getKind()) {
            case 1: {
                this.elementAdded(element);
                break;
            }
            case 2: {
                this.elementRemoved(element);
                break;
            }
            case 4: {
                if ((delta.getFlags() & 1) == 0) break;
                this.elementChanged(element);
            }
        }
        if (processChildren) {
            IEGLElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                IEGLElementDelta childDelta = children[i];
                this.traverseDelta(childDelta, root, project);
                ++i;
            }
        }
    }
}

