/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.edt.ide.core.internal.model.EGLModelInfo;
import org.eclipse.edt.ide.core.internal.model.ElementCache;
import org.eclipse.edt.ide.core.internal.model.OverflowingLRUCache;
import org.eclipse.edt.ide.core.model.IEGLElement;

public class EGLModelCache {
    public static final int DEFAULT_PROJECT_SIZE = 5;
    public static final int PKG_CACHE_SIZE = 500;
    public static final int OPENABLE_CACHE_SIZE = 2000;
    protected EGLModelInfo modelInfo;
    protected Map rootCache = new HashMap(50);
    protected Map<IEGLElement, Object> projectCache = new HashMap<IEGLElement, Object>(5);
    protected Map pkgCache = new HashMap(500);
    protected OverflowingLRUCache openableCache = new ElementCache(2000);
    protected Map childrenCache = new HashMap(40000);

    public double openableFillingRatio() {
        return this.openableCache.fillingRatio();
    }

    public int pkgSize() {
        return this.pkgCache.size();
    }

    public Object getInfo(IEGLElement element) {
        try {
            switch (element.getElementType()) {
                case 1: {
                    return this.modelInfo;
                }
                case 2: {
                    return this.projectCache.get(element);
                }
                case 3: {
                    return this.rootCache.get(element);
                }
                case 4: {
                    return this.pkgCache.get(element);
                }
                case 6: {
                    return this.openableCache.get(element);
                }
            }
            return this.childrenCache.get(element);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected Object peekAtInfo(IEGLElement element) {
        switch (element.getElementType()) {
            case 1: {
                return this.modelInfo;
            }
            case 2: {
                return this.projectCache.get(element);
            }
            case 3: {
                return this.rootCache.get(element);
            }
            case 4: {
                return this.pkgCache.get(element);
            }
            case 6: {
                return this.openableCache.get(element);
            }
        }
        return this.childrenCache.get(element);
    }

    protected void resetJarTypeCache() {
    }

    protected void putInfo(IEGLElement element, Object info) {
        switch (element.getElementType()) {
            case 1: {
                this.modelInfo = (EGLModelInfo)info;
                break;
            }
            case 2: {
                this.projectCache.put(element, info);
                break;
            }
            case 3: {
                this.rootCache.put(element, info);
                break;
            }
            case 4: {
                this.pkgCache.put(element, info);
                break;
            }
            case 6: {
                this.openableCache.put(element, info);
                break;
            }
            default: {
                this.childrenCache.put(element, info);
            }
        }
    }

    protected void removeInfo(IEGLElement element) {
        switch (element.getElementType()) {
            case 1: {
                this.modelInfo = null;
                break;
            }
            case 2: {
                this.projectCache.remove(element);
                break;
            }
            case 3: {
                this.rootCache.remove(element);
                break;
            }
            case 4: {
                this.pkgCache.remove(element);
                break;
            }
            case 6: {
                this.openableCache.remove(element);
                break;
            }
            default: {
                this.childrenCache.remove(element);
            }
        }
    }
}

