/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.util.Map;
import org.eclipse.edt.ide.core.internal.model.EGLElementDelta;
import org.eclipse.edt.ide.core.internal.model.EGLFile;
import org.eclipse.edt.ide.core.internal.model.EGLModelOperation;
import org.eclipse.edt.ide.core.internal.model.WorkingCopy;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IBufferFactory;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IProblemRequestor;

public class CreateWorkingCopyOperation
extends EGLModelOperation {
    Map perFactoryWorkingCopies;
    IBufferFactory factory;
    IProblemRequestor problemRequestor;

    public CreateWorkingCopyOperation(IEGLFile originalElement, Map perFactoryWorkingCopies, IBufferFactory factory, IProblemRequestor problemRequestor) {
        super(new IEGLElement[]{originalElement});
        this.perFactoryWorkingCopies = perFactoryWorkingCopies;
        this.factory = factory;
        this.problemRequestor = problemRequestor;
    }

    @Override
    protected void executeOperation() throws EGLModelException {
        IEGLFile cu = this.getEGLFile();
        WorkingCopy workingCopy = new WorkingCopy((IPackageFragment)cu.getParent(), cu.getElementName(), this.factory, this.problemRequestor);
        workingCopy.open(this.fMonitor);
        if (this.perFactoryWorkingCopies != null) {
            this.perFactoryWorkingCopies.put(cu, workingCopy);
            if (EGLFile.SHARED_WC_VERBOSE) {
                System.out.println("Creating shared working copy " + workingCopy.toStringWithAncestors());
            }
        }
        EGLElementDelta delta = new EGLElementDelta(this.getEGLModel());
        delta.added(workingCopy);
        this.addDelta(delta);
        this.fResultElements = new IEGLElement[]{workingCopy};
    }

    protected IEGLFile getEGLFile() {
        return (IEGLFile)this.getElementToProcess();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }
}

