/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.edt.ide.core.internal.model.EGLElementDeltaBuilder;
import org.eclipse.edt.ide.core.internal.model.EGLFile;
import org.eclipse.edt.ide.core.internal.model.EGLModelOperation;
import org.eclipse.edt.ide.core.internal.model.EGLModelResources;
import org.eclipse.edt.ide.core.internal.model.EGLModelStatus;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.internal.model.WorkingCopy;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IBuffer;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLModelStatus;
import org.eclipse.edt.ide.core.model.IWorkingCopy;

public class CommitWorkingCopyOperation
extends EGLModelOperation {
    public CommitWorkingCopyOperation(IEGLFile element, boolean force) {
        super(new IEGLElement[]{element}, force);
    }

    @Override
    protected void executeOperation() throws EGLModelException {
        try {
            this.beginTask(EGLModelResources.workingCopyCommit, 2);
            WorkingCopy copy = (WorkingCopy)this.getEGLFile();
            IEGLFile original = (IEGLFile)copy.getOriginalElement();
            if (!original.isOpen()) {
                original.open(null);
            }
            EGLElementDeltaBuilder deltaBuilder = Util.isExcluded(original) ? null : new EGLElementDeltaBuilder(original);
            IBuffer originalBuffer = original.getBuffer();
            if (originalBuffer == null) {
                return;
            }
            char[] originalContents = originalBuffer.getCharacters();
            boolean hasSaved = false;
            try {
                IBuffer copyBuffer = copy.getBuffer();
                if (copyBuffer == null) {
                    return;
                }
                originalBuffer.setContents(copyBuffer.getCharacters());
                original.save(this.fMonitor, this.fForce);
                this.setAttribute("hasModifiedResource", "true");
                hasSaved = true;
            }
            finally {
                if (!hasSaved) {
                    originalBuffer.setContents(originalContents);
                }
            }
            copy.updateTimeStamp((EGLFile)original);
            copy.makeConsistent(this);
            this.worked(1);
            if (deltaBuilder != null) {
                deltaBuilder.buildDeltas();
                if (deltaBuilder.delta != null) {
                    this.addDelta(deltaBuilder.delta);
                }
            }
            this.worked(1);
        }
        finally {
            this.done();
        }
    }

    protected IEGLFile getEGLFile() {
        return (IEGLFile)this.getElementToProcess();
    }

    @Override
    public IEGLModelStatus verify() {
        IEGLFile cu = this.getEGLFile();
        if (!cu.isWorkingCopy()) {
            return new EGLModelStatus(967, cu);
        }
        IEGLFile original = (IEGLFile)cu.getOriginalElement();
        IResource resource = original.getResource();
        if (!cu.isBasedOn(resource) && !this.fForce) {
            return new EGLModelStatus(981);
        }
        return EGLModelStatus.VERIFIED_OK;
    }

    @Override
    protected ISchedulingRule getSchedulingRule() {
        IResource resource = ((IWorkingCopy)((Object)this.getElementToProcess())).getOriginalElement().getResource();
        IWorkspace workspace = resource.getWorkspace();
        if (resource.exists()) {
            return workspace.getRuleFactory().modifyRule(resource);
        }
        return workspace.getRuleFactory().createRule(resource);
    }
}

